/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import org.apache.kafka.coordinator.common.runtime.CoordinatorExecutor;
import org.apache.kafka.coordinator.common.runtime.CoordinatorResult;

public class MockCoordinatorExecutor<T>
implements CoordinatorExecutor<T> {
    private final Map<String, CoordinatorExecutor.TaskRunnable<?>> tasks = new HashMap();
    private final Queue<ExecutorTask<?>> queue = new ArrayDeque();

    public <R> boolean schedule(String key, CoordinatorExecutor.TaskRunnable<R> task, CoordinatorExecutor.TaskOperation<T, R> operation) {
        if (this.tasks.putIfAbsent(key, task) != null) {
            return false;
        }
        return this.queue.add(new ExecutorTask<R>(key, task, operation));
    }

    public boolean isScheduled(String key) {
        return this.tasks.containsKey(key);
    }

    public int size() {
        return this.queue.size();
    }

    public void cancel(String key) {
        this.tasks.remove(key);
    }

    public List<ExecutorResult<T>> poll() {
        ArrayList<ExecutorResult<T>> results = new ArrayList<ExecutorResult<T>>();
        for (ExecutorTask executorTask : this.queue) {
            this.tasks.remove(executorTask.key, executorTask.task);
            results.add(new ExecutorResult(executorTask.key, executorTask.execute()));
        }
        this.queue.clear();
        return results;
    }

    private class ExecutorTask<R> {
        public final String key;
        public final CoordinatorExecutor.TaskRunnable<R> task;
        public final CoordinatorExecutor.TaskOperation<T, R> operation;

        ExecutorTask(String key, CoordinatorExecutor.TaskRunnable<R> task, CoordinatorExecutor.TaskOperation<T, R> operation) {
            this.key = Objects.requireNonNull(key);
            this.task = Objects.requireNonNull(task);
            this.operation = Objects.requireNonNull(operation);
        }

        CoordinatorResult<Void, T> execute() {
            try {
                return this.operation.onComplete(this.task.run(), null);
            }
            catch (Throwable ex) {
                return this.operation.onComplete(null, ex);
            }
        }
    }

    public static class ExecutorResult<T> {
        public final String key;
        public final CoordinatorResult<Void, T> result;

        public ExecutorResult(String key, CoordinatorResult<Void, T> result) {
            this.key = Objects.requireNonNull(key);
            this.result = Objects.requireNonNull(result);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecutorResult that = (ExecutorResult)o;
            if (!Objects.equals(this.key, that.key)) {
                return false;
            }
            return Objects.equals(this.result, that.result);
        }

        public int hashCode() {
            int result = this.key.hashCode();
            result = 31 * result + this.result.hashCode();
            return result;
        }

        public String toString() {
            return "ExecutorResult(key='" + this.key + "', result=" + String.valueOf(this.result) + ")";
        }
    }
}

