/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.coordinator.common.runtime.KafkaMetricHistogram;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class KafkaMetricHistogramTest {
    @Test
    public void testStats() {
        try (Metrics metrics = new Metrics();){
            KafkaMetricHistogram histogram = KafkaMetricHistogram.newLatencyHistogram(suffix -> metrics.metricName("test-metric-" + suffix, "test-group", "test description"));
            Set<MetricName> expected = Set.of(new MetricName("test-metric-max", "test-group", "test description", Collections.emptyMap()), new MetricName("test-metric-p999", "test-group", "test description", Collections.emptyMap()), new MetricName("test-metric-p99", "test-group", "test description", Collections.emptyMap()), new MetricName("test-metric-p95", "test-group", "test description", Collections.emptyMap()), new MetricName("test-metric-p50", "test-group", "test description", Collections.emptyMap()));
            Set actual = histogram.stats().stream().map(CompoundStat.NamedMeasurable::name).collect(Collectors.toSet());
            Assertions.assertEquals(expected, actual);
        }
    }
}

