/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class CoordinatorRecordTest {
    @Test
    public void testAttributes() {
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)Mockito.mock(ApiMessage.class), 0);
        ApiMessageAndVersion value = new ApiMessageAndVersion((ApiMessage)Mockito.mock(ApiMessage.class), 0);
        CoordinatorRecord record = new CoordinatorRecord(key, value);
        Assertions.assertEquals((Object)key, (Object)record.key());
        Assertions.assertEquals((Object)value, (Object)record.value());
    }

    @Test
    public void testKeyCannotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new CoordinatorRecord(null, null));
    }

    @Test
    public void testValueCanBeNull() {
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)Mockito.mock(ApiMessage.class), 0);
        CoordinatorRecord record = new CoordinatorRecord(key, null);
        Assertions.assertEquals((Object)key, (Object)record.key());
        Assertions.assertNull((Object)record.value());
    }

    @Test
    public void testEquals() {
        ApiMessageAndVersion key = new ApiMessageAndVersion((ApiMessage)Mockito.mock(ApiMessage.class), 0);
        ApiMessageAndVersion value = new ApiMessageAndVersion((ApiMessage)Mockito.mock(ApiMessage.class), 0);
        CoordinatorRecord record1 = new CoordinatorRecord(key, value);
        CoordinatorRecord record2 = new CoordinatorRecord(key, value);
        Assertions.assertEquals((Object)record1, (Object)record2);
    }
}

