/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.MappedIterator;
import org.junit.Assert;
import org.junit.Test;

public class MappedIteratorTest {
    @Test
    public void testStringToInteger() {
        List<String> list = Arrays.asList("foo", "", "bar2", "baz45");
        Function<String, Integer> mapper = s -> s.length();
        Iterable<Integer> mappedIterable = () -> new MappedIterator(list.iterator(), mapper);
        ArrayList mapped = new ArrayList();
        mappedIterable.forEach(mapped::add);
        Assert.assertEquals(list.stream().map(mapper).collect(Collectors.toList()), mapped);
        ArrayList mapped2 = new ArrayList();
        mappedIterable.forEach(mapped2::add);
        Assert.assertEquals(mapped, mapped2);
    }

    @Test
    public void testEmptyList() {
        List list = Collections.emptyList();
        Function<String, Integer> mapper = s -> s.length();
        Iterable<Integer> mappedIterable = () -> new MappedIterator(list.iterator(), mapper);
        ArrayList mapped = new ArrayList();
        mappedIterable.forEach(mapped::add);
        Assert.assertEquals(Collections.emptyList(), mapped);
    }
}

