/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.utils.ConfigUtils;
import org.junit.Assert;
import org.junit.Test;

public class ConfigUtilsTest {
    private static final ConfigDef CONFIG = new ConfigDef().define("foo", ConfigDef.Type.PASSWORD, ConfigDef.Importance.HIGH, "").define("bar", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "").define("quux", ConfigDef.Type.INT, ConfigDef.Importance.HIGH, "").define("blah", ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, "");

    @Test
    public void testTranslateDeprecated() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("foo.bar", "baz");
        config.put("foo.bar.deprecated", "quux");
        config.put("chicken", "1");
        config.put("rooster", "2");
        config.put("hen", "3");
        config.put("heifer", "moo");
        config.put("blah", "blah");
        config.put("unexpected.non.string.object", 42);
        Map newConfig = ConfigUtils.translateDeprecatedConfigs(config, (String[][])new String[][]{{"foo.bar", "foo.bar.deprecated"}, {"chicken", "rooster", "hen"}, {"cow", "beef", "heifer", "steer"}});
        Assert.assertEquals((Object)"baz", newConfig.get("foo.bar"));
        Assert.assertEquals(null, newConfig.get("foobar.deprecated"));
        Assert.assertEquals((Object)"1", newConfig.get("chicken"));
        Assert.assertEquals(null, newConfig.get("rooster"));
        Assert.assertEquals(null, newConfig.get("hen"));
        Assert.assertEquals((Object)"moo", newConfig.get("cow"));
        Assert.assertEquals(null, newConfig.get("beef"));
        Assert.assertEquals(null, newConfig.get("heifer"));
        Assert.assertEquals(null, newConfig.get("steer"));
        Assert.assertEquals(null, config.get("cow"));
        Assert.assertEquals((Object)"blah", config.get("blah"));
        Assert.assertEquals((Object)"blah", newConfig.get("blah"));
        Assert.assertEquals((Object)42, newConfig.get("unexpected.non.string.object"));
        Assert.assertEquals((Object)42, config.get("unexpected.non.string.object"));
    }

    @Test
    public void testAllowsNewKey() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("foo.bar", "baz");
        Map newConfig = ConfigUtils.translateDeprecatedConfigs(config, (String[][])new String[][]{{"foo.bar", "foo.bar.deprecated"}, {"chicken", "rooster", "hen"}, {"cow", "beef", "heifer", "steer"}});
        Assert.assertNotNull((Object)newConfig);
        Assert.assertEquals((Object)"baz", newConfig.get("foo.bar"));
        Assert.assertNull(newConfig.get("foo.bar.deprecated"));
    }

    @Test
    public void testAllowDeprecatedNulls() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("foo.bar.deprecated", null);
        config.put("foo.bar", "baz");
        Map newConfig = ConfigUtils.translateDeprecatedConfigs(config, (String[][])new String[][]{{"foo.bar", "foo.bar.deprecated"}});
        Assert.assertNotNull((Object)newConfig);
        Assert.assertEquals((Object)"baz", newConfig.get("foo.bar"));
        Assert.assertNull(newConfig.get("foo.bar.deprecated"));
    }

    @Test
    public void testAllowNullOverride() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("foo.bar.deprecated", "baz");
        config.put("foo.bar", null);
        Map newConfig = ConfigUtils.translateDeprecatedConfigs(config, (String[][])new String[][]{{"foo.bar", "foo.bar.deprecated"}});
        Assert.assertNotNull((Object)newConfig);
        Assert.assertNull(newConfig.get("foo.bar"));
        Assert.assertNull(newConfig.get("foo.bar.deprecated"));
    }

    @Test
    public void testNullMapEntriesWithoutAliasesDoNotThrowNPE() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("other", null);
        Map newConfig = ConfigUtils.translateDeprecatedConfigs(config, (String[][])new String[][]{{"foo.bar", "foo.bar.deprecated"}});
        Assert.assertNotNull((Object)newConfig);
        Assert.assertNull(newConfig.get("other"));
    }

    @Test
    public void testDuplicateSynonyms() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("foo.bar", "baz");
        config.put("foo.bar.deprecated", "derp");
        Map newConfig = ConfigUtils.translateDeprecatedConfigs(config, (String[][])new String[][]{{"foo.bar", "foo.bar.deprecated"}, {"chicken", "foo.bar.deprecated"}});
        Assert.assertNotNull((Object)newConfig);
        Assert.assertEquals((Object)"baz", newConfig.get("foo.bar"));
        Assert.assertEquals((Object)"derp", newConfig.get("chicken"));
        Assert.assertNull(newConfig.get("foo.bar.deprecated"));
    }

    @Test
    public void testMultipleDeprecations() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("foo.bar.deprecated", "derp");
        config.put("foo.bar.even.more.deprecated", "very old configuration");
        Map newConfig = ConfigUtils.translateDeprecatedConfigs(config, (String[][])new String[][]{{"foo.bar", "foo.bar.deprecated", "foo.bar.even.more.deprecated"}});
        Assert.assertNotNull((Object)newConfig);
        Assert.assertEquals((Object)"derp", newConfig.get("foo.bar"));
        Assert.assertNull(newConfig.get("foo.bar.deprecated"));
        Assert.assertNull(newConfig.get("foo.bar.even.more.deprecated"));
    }

    @Test
    public void testConfigMapToRedactedStringForEmptyMap() {
        Assert.assertEquals((Object)"{}", (Object)ConfigUtils.configMapToRedactedString(Collections.emptyMap(), (ConfigDef)CONFIG));
    }

    @Test
    public void testConfigMapToRedactedStringWithSecrets() {
        HashMap<String, Object> testMap1 = new HashMap<String, Object>();
        testMap1.put("bar", "whatever");
        testMap1.put("quux", 123);
        testMap1.put("foo", "foosecret");
        testMap1.put("blah", null);
        testMap1.put("quuux", 456);
        Assert.assertEquals((Object)"{bar=\"whatever\", blah=null, foo=(redacted), quuux=(redacted), quux=123}", (Object)ConfigUtils.configMapToRedactedString(testMap1, (ConfigDef)CONFIG));
    }
}

