/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.internals;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.IntGaugeSuite;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntGaugeSuiteTest {
    private static final Logger log = LoggerFactory.getLogger(IntGaugeSuiteTest.class);

    private static IntGaugeSuite<String> createIntGaugeSuite() {
        MetricConfig config = new MetricConfig();
        Metrics metrics = new Metrics(config);
        IntGaugeSuite suite = new IntGaugeSuite(log, "mySuite", metrics, name -> new MetricName(name, "group", "myMetric", Collections.emptyMap()), 3);
        return suite;
    }

    @Test
    public void testCreateAndClose() {
        IntGaugeSuite<String> suite = IntGaugeSuiteTest.createIntGaugeSuite();
        Assert.assertEquals((long)3L, (long)suite.maxEntries());
        suite.close();
        suite.close();
        suite.metrics().close();
    }

    @Test
    public void testCreateMetrics() {
        IntGaugeSuite<String> suite = IntGaugeSuiteTest.createIntGaugeSuite();
        suite.increment((Object)"foo");
        Map values = suite.values();
        Assert.assertEquals((Object)1, values.get("foo"));
        Assert.assertEquals((long)1L, (long)values.size());
        suite.increment((Object)"foo");
        suite.increment((Object)"bar");
        suite.increment((Object)"baz");
        suite.increment((Object)"quux");
        values = suite.values();
        Assert.assertEquals((Object)2, values.get("foo"));
        Assert.assertEquals((Object)1, values.get("bar"));
        Assert.assertEquals((Object)1, values.get("baz"));
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertFalse((boolean)values.containsKey("quux"));
        suite.close();
        suite.metrics().close();
    }

    @Test
    public void testCreateAndRemoveMetrics() {
        IntGaugeSuite<String> suite = IntGaugeSuiteTest.createIntGaugeSuite();
        suite.increment((Object)"foo");
        suite.decrement((Object)"foo");
        suite.increment((Object)"foo");
        suite.increment((Object)"foo");
        suite.increment((Object)"bar");
        suite.decrement((Object)"bar");
        suite.increment((Object)"baz");
        suite.increment((Object)"quux");
        Map values = suite.values();
        Assert.assertEquals((Object)2, values.get("foo"));
        Assert.assertFalse((boolean)values.containsKey("bar"));
        Assert.assertEquals((Object)1, values.get("baz"));
        Assert.assertEquals((Object)1, values.get("quux"));
        Assert.assertEquals((long)3L, (long)values.size());
        suite.close();
        suite.metrics().close();
    }
}

