/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config;

import java.util.Arrays;
import org.apache.kafka.common.config.ConfigResource;
import org.junit.Assert;
import org.junit.Test;

public class ConfigResourceTest {
    @Test
    public void shouldGetTypeFromId() {
        Assert.assertEquals((Object)ConfigResource.Type.TOPIC, (Object)ConfigResource.Type.forId((byte)2));
        Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)ConfigResource.Type.forId((byte)4));
    }

    @Test
    public void shouldReturnUnknownForUnknownCode() {
        Assert.assertEquals((Object)ConfigResource.Type.UNKNOWN, (Object)ConfigResource.Type.forId((byte)-1));
        Assert.assertEquals((Object)ConfigResource.Type.UNKNOWN, (Object)ConfigResource.Type.forId((byte)0));
        Assert.assertEquals((Object)ConfigResource.Type.UNKNOWN, (Object)ConfigResource.Type.forId((byte)1));
    }

    @Test
    public void shouldRoundTripEveryType() {
        Arrays.stream(ConfigResource.Type.values()).forEach(type -> Assert.assertEquals((String)type.toString(), (Object)type, (Object)ConfigResource.Type.forId((byte)type.id())));
    }
}

