/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.clients.admin.MemberAssignment;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;

public class MemberDescriptionTest {
    private static final String MEMBER_ID = "member_id";
    private static final Optional<String> INSTANCE_ID = Optional.of("instanceId");
    private static final String CLIENT_ID = "client_id";
    private static final String HOST = "host";
    private static final MemberAssignment ASSIGNMENT = new MemberAssignment(Collections.singleton(new TopicPartition("topic", 1)));
    private static final MemberDescription STATIC_MEMBER_DESCRIPTION = new MemberDescription("member_id", INSTANCE_ID, "client_id", "host", ASSIGNMENT);

    @Test
    public void testEqualsWithoutGroupInstanceId() {
        MemberDescription dynamicMemberDescription = new MemberDescription(MEMBER_ID, CLIENT_ID, HOST, ASSIGNMENT);
        MemberDescription identityDescription = new MemberDescription(MEMBER_ID, CLIENT_ID, HOST, ASSIGNMENT);
        Assert.assertNotEquals((Object)STATIC_MEMBER_DESCRIPTION, (Object)dynamicMemberDescription);
        Assert.assertNotEquals((long)STATIC_MEMBER_DESCRIPTION.hashCode(), (long)dynamicMemberDescription.hashCode());
        Assert.assertEquals((Object)dynamicMemberDescription, (Object)dynamicMemberDescription);
        Assert.assertEquals((Object)dynamicMemberDescription, (Object)identityDescription);
        Assert.assertEquals((long)dynamicMemberDescription.hashCode(), (long)identityDescription.hashCode());
    }

    @Test
    public void testEqualsWithGroupInstanceId() {
        Assert.assertEquals((Object)STATIC_MEMBER_DESCRIPTION, (Object)STATIC_MEMBER_DESCRIPTION);
        MemberDescription identityDescription = new MemberDescription(MEMBER_ID, INSTANCE_ID, CLIENT_ID, HOST, ASSIGNMENT);
        Assert.assertEquals((Object)STATIC_MEMBER_DESCRIPTION, (Object)identityDescription);
        Assert.assertEquals((long)STATIC_MEMBER_DESCRIPTION.hashCode(), (long)identityDescription.hashCode());
    }

    @Test
    public void testNonEqual() {
        MemberDescription newMemberDescription = new MemberDescription("new_member", INSTANCE_ID, CLIENT_ID, HOST, ASSIGNMENT);
        Assert.assertNotEquals((Object)STATIC_MEMBER_DESCRIPTION, (Object)newMemberDescription);
        Assert.assertNotEquals((long)STATIC_MEMBER_DESCRIPTION.hashCode(), (long)newMemberDescription.hashCode());
        MemberDescription newInstanceDescription = new MemberDescription(MEMBER_ID, Optional.of("new_instance"), CLIENT_ID, HOST, ASSIGNMENT);
        Assert.assertNotEquals((Object)STATIC_MEMBER_DESCRIPTION, (Object)newInstanceDescription);
        Assert.assertNotEquals((long)STATIC_MEMBER_DESCRIPTION.hashCode(), (long)newInstanceDescription.hashCode());
    }
}

