/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.utils.Time;

public class MockSelector
implements Selectable {
    private final Time time;
    private final List<Send> initiatedSends = new ArrayList<Send>();
    private final List<Send> completedSends = new ArrayList<Send>();
    private final List<NetworkReceive> completedReceives = new ArrayList<NetworkReceive>();
    private final List<String> disconnected = new ArrayList<String>();
    private final List<String> connected = new ArrayList<String>();

    public MockSelector(Time time) {
        this.time = time;
    }

    public void connect(String id, InetSocketAddress address, int sendBufferSize, int receiveBufferSize) throws IOException {
        this.connected.add(id);
    }

    public void wakeup() {
    }

    public void close() {
    }

    public void close(String id) {
        this.disconnected.add(id);
        for (int i = 0; i < this.connected.size(); ++i) {
            if (!this.connected.get(i).equals(id)) continue;
            this.connected.remove(i);
            break;
        }
    }

    public void clear() {
        this.completedSends.clear();
        this.completedReceives.clear();
        this.disconnected.clear();
        this.connected.clear();
    }

    public void send(Send send) {
        this.initiatedSends.add(send);
    }

    public void poll(long timeout) throws IOException {
        this.completedSends.addAll(this.initiatedSends);
        this.initiatedSends.clear();
        this.time.sleep(timeout);
    }

    public List<Send> completedSends() {
        return this.completedSends;
    }

    public void completeSend(NetworkSend send) {
        this.completedSends.add((Send)send);
    }

    public List<NetworkReceive> completedReceives() {
        return this.completedReceives;
    }

    public void completeReceive(NetworkReceive receive) {
        this.completedReceives.add(receive);
    }

    public List<String> disconnected() {
        return this.disconnected;
    }

    public List<String> connected() {
        return this.connected;
    }

    public void mute(String id) {
    }

    public void unmute(String id) {
    }

    public void muteAll() {
    }

    public void unmuteAll() {
    }

    public boolean isChannelReady(String id) {
        return true;
    }
}

