/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.protocol;

import java.util.HashSet;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.protocol.Errors;
import org.junit.Assert;
import org.junit.Test;

public class ErrorsTest {
    @Test
    public void testUniqueErrorCodes() {
        HashSet<Short> codeSet = new HashSet<Short>();
        for (Errors error : Errors.values()) {
            codeSet.add(error.code());
        }
        Assert.assertEquals((String)"Error codes must be unique", (long)codeSet.size(), (long)Errors.values().length);
    }

    @Test
    public void testUniqueExceptions() {
        HashSet exceptionSet = new HashSet();
        for (Errors error : Errors.values()) {
            if (error == Errors.NONE) continue;
            exceptionSet.add(error.exception().getClass());
        }
        Assert.assertEquals((String)"Exceptions must be unique", (long)exceptionSet.size(), (long)(Errors.values().length - 1));
    }

    @Test
    public void testExceptionsAreNotGeneric() {
        for (Errors error : Errors.values()) {
            if (error == Errors.NONE) continue;
            Assert.assertNotEquals((String)"Generic ApiException should not be used", error.exception().getClass(), ApiException.class);
        }
    }

    @Test
    public void testNoneException() {
        Assert.assertNull((String)"The NONE error should not have an exception", (Object)Errors.NONE.exception());
    }

    @Test
    public void testForExceptionInheritance() {
        Errors expectedError = Errors.forException((Throwable)new TimeoutException());
        class ExtendedTimeoutException
        extends TimeoutException {
            ExtendedTimeoutException() {
            }
        }
        Errors actualError = Errors.forException((Throwable)((Object)new ExtendedTimeoutException()));
        Assert.assertEquals((String)"forException should match super classes", (Object)expectedError, (Object)actualError);
    }

    @Test
    public void testForExceptionDefault() {
        Errors error = Errors.forException((Throwable)new ApiException());
        Assert.assertEquals((String)"forException should default to unknown", (Object)Errors.UNKNOWN, (Object)error);
    }
}

