/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Map;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.EchoServer;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.SelectorTest;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.SslChannelBuilder;
import org.apache.kafka.common.network.SslTransportLayer;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.test.TestSslUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SslSelectorTest
extends SelectorTest {
    private Metrics metrics;
    private Map<String, Object> sslClientConfigs;

    @Override
    @Before
    public void setUp() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> sslServerConfigs = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        sslServerConfigs.put("principal.builder.class", Class.forName("org.apache.kafka.common.security.auth.DefaultPrincipalBuilder"));
        this.server = new EchoServer(SecurityProtocol.SSL, sslServerConfigs);
        this.server.start();
        this.time = new MockTime();
        this.sslClientConfigs = TestSslUtils.createSslConfig(false, false, Mode.CLIENT, trustStoreFile, "client");
        this.channelBuilder = new SslChannelBuilder(Mode.CLIENT);
        this.channelBuilder.configure(this.sslClientConfigs);
        this.metrics = new Metrics();
        this.selector = new Selector(5000L, this.metrics, this.time, "MetricGroup", this.channelBuilder);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.selector.close();
        this.server.close();
        this.metrics.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenegotiation() throws Exception {
        SslChannelBuilder channelBuilder = new SslChannelBuilder(Mode.CLIENT){

            protected SslTransportLayer buildTransportLayer(SslFactory sslFactory, String id, SelectionKey key) throws IOException {
                SocketChannel socketChannel = (SocketChannel)key.channel();
                SslTransportLayer transportLayer = new SslTransportLayer(id, key, sslFactory.createSslEngine(socketChannel.socket().getInetAddress().getHostName(), socketChannel.socket().getPort()), true);
                transportLayer.startHandshake();
                return transportLayer;
            }
        };
        channelBuilder.configure(this.sslClientConfigs);
        try (Selector selector = new Selector(5000L, this.metrics, this.time, "MetricGroup2", (ChannelBuilder)channelBuilder);){
            int reqs = 500;
            String node = "0";
            InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port);
            selector.connect(node, addr, 4096, 4096);
            int requests = 0;
            int responses = 0;
            int renegotiates = 0;
            while (!selector.isChannelReady(node)) {
                selector.poll(1000L);
            }
            selector.send((Send)this.createSend(node, node + "-" + 0));
            ++requests;
            while (responses < reqs) {
                selector.poll(0L);
                if (responses >= 100 && renegotiates == 0) {
                    ++renegotiates;
                    this.server.renegotiate();
                }
                Assert.assertEquals((String)"No disconnects should have occurred.", (long)0L, (long)selector.disconnected().size());
                for (NetworkReceive receive : selector.completedReceives()) {
                    String[] pieces = this.asString(receive).split("-");
                    Assert.assertEquals((String)"Should be in the form 'conn-counter'", (long)2L, (long)pieces.length);
                    Assert.assertEquals((String)"Check the source", (Object)receive.source(), (Object)pieces[0]);
                    Assert.assertEquals((String)"Check that the receive has kindly been rewound", (long)0L, (long)receive.payload().position());
                    Assert.assertEquals((String)"Check the request counter", (long)responses, (long)Integer.parseInt(pieces[1]));
                    ++responses;
                }
                for (int i = 0; i < selector.completedSends().size() && requests < reqs && selector.isChannelReady(node); ++i, ++requests) {
                    selector.send((Send)this.createSend(node, node + "-" + requests));
                }
            }
        }
    }

    @Test
    public void testDisabledRenegotiation() throws Exception {
        String node = "0";
        InetSocketAddress addr = new InetSocketAddress("localhost", this.server.port);
        this.selector.connect(node, addr, 4096, 4096);
        while (!this.selector.isChannelReady(node)) {
            this.selector.poll(1000L);
        }
        this.selector.send((Send)this.createSend(node, node + "-" + 0));
        this.selector.poll(0L);
        this.server.renegotiate();
        this.selector.send((Send)this.createSend(node, node + "-" + 1));
        long expiryTime = System.currentTimeMillis() + 2000L;
        ArrayList disconnected = new ArrayList();
        while (!disconnected.contains(node) && System.currentTimeMillis() < expiryTime) {
            this.selector.poll(10L);
            disconnected.addAll(this.selector.disconnected());
        }
        Assert.assertTrue((String)"Renegotiation should cause disconnection", (boolean)disconnected.contains(node));
    }

    @Override
    protected void connect(String node, InetSocketAddress serverAddr) throws IOException {
        this.blockingConnect(node, serverAddr);
    }
}

