/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.cache;

import org.apache.kafka.common.cache.LRUCache;
import org.junit.Assert;
import org.junit.Test;

public class LRUCacheTest {
    @Test
    public void testPutGet() {
        LRUCache cache = new LRUCache(4);
        cache.put((Object)"a", (Object)"b");
        cache.put((Object)"c", (Object)"d");
        cache.put((Object)"e", (Object)"f");
        cache.put((Object)"g", (Object)"h");
        Assert.assertEquals((long)4L, (long)cache.size());
        Assert.assertEquals((Object)"b", (Object)cache.get((Object)"a"));
        Assert.assertEquals((Object)"d", (Object)cache.get((Object)"c"));
        Assert.assertEquals((Object)"f", (Object)cache.get((Object)"e"));
        Assert.assertEquals((Object)"h", (Object)cache.get((Object)"g"));
    }

    @Test
    public void testRemove() {
        LRUCache cache = new LRUCache(4);
        cache.put((Object)"a", (Object)"b");
        cache.put((Object)"c", (Object)"d");
        cache.put((Object)"e", (Object)"f");
        Assert.assertEquals((long)3L, (long)cache.size());
        Assert.assertEquals((Object)true, (Object)cache.remove((Object)"a"));
        Assert.assertEquals((long)2L, (long)cache.size());
        Assert.assertNull((Object)cache.get((Object)"a"));
        Assert.assertEquals((Object)"d", (Object)cache.get((Object)"c"));
        Assert.assertEquals((Object)"f", (Object)cache.get((Object)"e"));
        Assert.assertEquals((Object)false, (Object)cache.remove((Object)"key-does-not-exist"));
        Assert.assertEquals((Object)true, (Object)cache.remove((Object)"c"));
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertNull((Object)cache.get((Object)"c"));
        Assert.assertEquals((Object)"f", (Object)cache.get((Object)"e"));
        Assert.assertEquals((Object)true, (Object)cache.remove((Object)"e"));
        Assert.assertEquals((long)0L, (long)cache.size());
        Assert.assertNull((Object)cache.get((Object)"e"));
    }

    @Test
    public void testEviction() {
        LRUCache cache = new LRUCache(2);
        cache.put((Object)"a", (Object)"b");
        cache.put((Object)"c", (Object)"d");
        Assert.assertEquals((long)2L, (long)cache.size());
        cache.put((Object)"e", (Object)"f");
        Assert.assertEquals((long)2L, (long)cache.size());
        Assert.assertNull((Object)cache.get((Object)"a"));
        Assert.assertEquals((Object)"d", (Object)cache.get((Object)"c"));
        Assert.assertEquals((Object)"f", (Object)cache.get((Object)"e"));
        cache.get((Object)"c");
        cache.put((Object)"g", (Object)"h");
        Assert.assertEquals((long)2L, (long)cache.size());
        Assert.assertNull((Object)cache.get((Object)"e"));
        Assert.assertEquals((Object)"d", (Object)cache.get((Object)"c"));
        Assert.assertEquals((Object)"h", (Object)cache.get((Object)"g"));
    }
}

