/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;

public class SubscriptionStateTest {
    private final SubscriptionState state = new SubscriptionState(OffsetResetStrategy.EARLIEST);
    private final String topic = "test";
    private final String topic1 = "test1";
    private final TopicPartition tp0 = new TopicPartition("test", 0);
    private final TopicPartition tp1 = new TopicPartition("test", 1);
    private final MockRebalanceListener rebalanceListener = new MockRebalanceListener();

    @Test
    public void partitionAssignment() {
        this.state.assignFromUser(Arrays.asList(this.tp0));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)this.state.assignedPartitions());
        Assert.assertFalse((boolean)this.state.partitionAssignmentNeeded());
        this.state.committed(this.tp0, new OffsetAndMetadata(1L));
        this.state.seek(this.tp0, 1L);
        Assert.assertTrue((boolean)this.state.isFetchable(this.tp0));
        this.assertAllPositions(this.tp0, 1L);
        this.state.assignFromUser(Arrays.asList(new TopicPartition[0]));
        Assert.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assert.assertFalse((boolean)this.state.isAssigned(this.tp0));
        Assert.assertFalse((boolean)this.state.isFetchable(this.tp0));
    }

    @Test
    public void partitionReset() {
        this.state.assignFromUser(Arrays.asList(this.tp0));
        this.state.seek(this.tp0, 5L);
        Assert.assertEquals((long)5L, (long)this.state.position(this.tp0));
        this.state.needOffsetReset(this.tp0);
        Assert.assertFalse((boolean)this.state.isFetchable(this.tp0));
        Assert.assertTrue((boolean)this.state.isOffsetResetNeeded(this.tp0));
        Assert.assertEquals(null, (Object)this.state.position(this.tp0));
        this.state.seek(this.tp0, 0L);
        Assert.assertTrue((boolean)this.state.isFetchable(this.tp0));
        Assert.assertFalse((boolean)this.state.isOffsetResetNeeded(this.tp0));
    }

    @Test
    public void topicSubscription() {
        this.state.subscribe(Arrays.asList("test"), (ConsumerRebalanceListener)this.rebalanceListener);
        Assert.assertEquals((long)1L, (long)this.state.subscription().size());
        Assert.assertTrue((boolean)this.state.partitionAssignmentNeeded());
        Assert.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assert.assertTrue((boolean)this.state.partitionsAutoAssigned());
        this.state.assignFromSubscribed(Arrays.asList(this.tp0));
        this.state.seek(this.tp0, 1L);
        this.state.committed(this.tp0, new OffsetAndMetadata(1L));
        this.assertAllPositions(this.tp0, 1L);
        this.state.assignFromSubscribed(Arrays.asList(this.tp1));
        Assert.assertTrue((boolean)this.state.isAssigned(this.tp1));
        Assert.assertFalse((boolean)this.state.partitionAssignmentNeeded());
        Assert.assertFalse((boolean)this.state.isAssigned(this.tp0));
        Assert.assertFalse((boolean)this.state.isFetchable(this.tp1));
        Assert.assertEquals(Collections.singleton(this.tp1), (Object)this.state.assignedPartitions());
    }

    @Test
    public void partitionPause() {
        this.state.assignFromUser(Arrays.asList(this.tp0));
        this.state.seek(this.tp0, 100L);
        Assert.assertTrue((boolean)this.state.isFetchable(this.tp0));
        this.state.pause(this.tp0);
        Assert.assertFalse((boolean)this.state.isFetchable(this.tp0));
        this.state.resume(this.tp0);
        Assert.assertTrue((boolean)this.state.isFetchable(this.tp0));
    }

    @Test
    public void commitOffsetMetadata() {
        this.state.assignFromUser(Arrays.asList(this.tp0));
        this.state.committed(this.tp0, new OffsetAndMetadata(5L, "hi"));
        Assert.assertEquals((long)5L, (long)this.state.committed(this.tp0).offset());
        Assert.assertEquals((Object)"hi", (Object)this.state.committed(this.tp0).metadata());
    }

    @Test(expected=IllegalStateException.class)
    public void invalidPositionUpdate() {
        this.state.subscribe(Arrays.asList("test"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.assignFromSubscribed(Arrays.asList(this.tp0));
        this.state.position(this.tp0, 0L);
    }

    @Test(expected=IllegalStateException.class)
    public void cantChangePositionForNonAssignedPartition() {
        this.state.position(this.tp0, 1L);
    }

    public void assertAllPositions(TopicPartition tp, Long offset) {
        Assert.assertEquals((long)offset, (long)this.state.committed(tp).offset());
        Assert.assertEquals((Object)offset, (Object)this.state.position(tp));
    }

    @Test(expected=IllegalStateException.class)
    public void cantSubscribeTopicAndPattern() {
        this.state.subscribe(Arrays.asList("test"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
    }

    @Test(expected=IllegalStateException.class)
    public void cantSubscribePartitionAndPattern() {
        this.state.assignFromUser(Arrays.asList(this.tp0));
        this.state.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
    }

    @Test(expected=IllegalStateException.class)
    public void cantSubscribePatternAndTopic() {
        this.state.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.subscribe(Arrays.asList("test"), (ConsumerRebalanceListener)this.rebalanceListener);
    }

    @Test(expected=IllegalStateException.class)
    public void cantSubscribePatternAndPartition() {
        this.state.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.assignFromUser(Arrays.asList(this.tp0));
    }

    @Test
    public void patternSubscription() {
        this.state.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.changeSubscription(Arrays.asList("test", "test1"));
        Assert.assertEquals((String)"Expected subscribed topics count is incorrect", (long)2L, (long)this.state.subscription().size());
    }

    @Test
    public void unsubscribeUserAssignment() {
        this.state.assignFromUser(Arrays.asList(this.tp0, this.tp1));
        this.state.unsubscribe();
        this.state.subscribe(Arrays.asList("test"), (ConsumerRebalanceListener)this.rebalanceListener);
        Assert.assertEquals(Collections.singleton("test"), (Object)this.state.subscription());
    }

    @Test
    public void unsubscribeUserSubscribe() {
        this.state.subscribe(Arrays.asList("test"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.unsubscribe();
        this.state.assignFromUser(Arrays.asList(this.tp0));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)this.state.assignedPartitions());
    }

    @Test
    public void unsubscription() {
        this.state.subscribe(Pattern.compile(".*"), (ConsumerRebalanceListener)this.rebalanceListener);
        this.state.changeSubscription(Arrays.asList("test", "test1"));
        Assert.assertTrue((boolean)this.state.partitionAssignmentNeeded());
        this.state.assignFromSubscribed(Arrays.asList(this.tp1));
        Assert.assertEquals(Collections.singleton(this.tp1), (Object)this.state.assignedPartitions());
        Assert.assertFalse((boolean)this.state.partitionAssignmentNeeded());
        this.state.unsubscribe();
        Assert.assertEquals((long)0L, (long)this.state.subscription().size());
        Assert.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assert.assertTrue((boolean)this.state.partitionAssignmentNeeded());
        this.state.assignFromUser(Arrays.asList(this.tp0));
        Assert.assertEquals(Collections.singleton(this.tp0), (Object)this.state.assignedPartitions());
        Assert.assertFalse((boolean)this.state.partitionAssignmentNeeded());
        this.state.unsubscribe();
        Assert.assertEquals((long)0L, (long)this.state.subscription().size());
        Assert.assertTrue((boolean)this.state.assignedPartitions().isEmpty());
        Assert.assertTrue((boolean)this.state.partitionAssignmentNeeded());
    }

    private static class MockRebalanceListener
    implements ConsumerRebalanceListener {
        public Collection<TopicPartition> revoked;
        public Collection<TopicPartition> assigned;
        public int revokedCount = 0;
        public int assignedCount = 0;

        private MockRebalanceListener() {
        }

        public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
            this.assigned = partitions;
            ++this.assignedCount;
        }

        public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            this.revoked = partitions;
            ++this.revokedCount;
        }
    }
}

