/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.internals.RequestFuture;
import org.apache.kafka.clients.consumer.internals.RequestFutureAdapter;
import org.junit.Assert;
import org.junit.Test;

public class RequestFutureTest {
    @Test
    public void testComposeSuccessCase() {
        RequestFuture future = new RequestFuture();
        RequestFuture composed = future.compose((RequestFutureAdapter)new RequestFutureAdapter<String, Integer>(){

            public void onSuccess(String value, RequestFuture<Integer> future) {
                future.complete((Object)value.length());
            }
        });
        future.complete((Object)"hello");
        Assert.assertTrue((boolean)composed.isDone());
        Assert.assertTrue((boolean)composed.succeeded());
        Assert.assertEquals((long)5L, (long)((Integer)composed.value()).intValue());
    }

    @Test
    public void testComposeFailureCase() {
        RequestFuture future = new RequestFuture();
        RequestFuture composed = future.compose((RequestFutureAdapter)new RequestFutureAdapter<String, Integer>(){

            public void onSuccess(String value, RequestFuture<Integer> future) {
                future.complete((Object)value.length());
            }
        });
        RuntimeException e = new RuntimeException();
        future.raise(e);
        Assert.assertTrue((boolean)composed.isDone());
        Assert.assertTrue((boolean)composed.failed());
        Assert.assertEquals((Object)e, (Object)composed.exception());
    }
}

