/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestSend;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.MockSelector;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NetworkClientTest {
    private final int requestTimeoutMs = 1000;
    private MockTime time = new MockTime();
    private MockSelector selector = new MockSelector(this.time);
    private Metadata metadata = new Metadata(0L, Long.MAX_VALUE);
    private int nodeId = 1;
    private Cluster cluster = TestUtils.singletonCluster("test", this.nodeId);
    private Node node = (Node)this.cluster.nodes().get(0);
    private long reconnectBackoffMsTest = 10000L;
    private NetworkClient client = new NetworkClient((Selectable)this.selector, this.metadata, "mock", Integer.MAX_VALUE, this.reconnectBackoffMsTest, 65536, 65536, 1000, (Time)this.time);
    private NetworkClient clientWithStaticNodes = new NetworkClient((Selectable)this.selector, (MetadataUpdater)new ManualMetadataUpdater(Arrays.asList(this.node)), "mock-static", Integer.MAX_VALUE, 0L, 65536, 65536, 1000, (Time)this.time);

    @Before
    public void setup() {
        this.metadata.update(this.cluster, this.time.milliseconds());
    }

    @Test(expected=IllegalStateException.class)
    public void testSendToUnreadyNode() {
        RequestSend send = new RequestSend("5", this.client.nextRequestHeader(ApiKeys.METADATA), new MetadataRequest(Arrays.asList("test")).toStruct());
        ClientRequest request = new ClientRequest(this.time.milliseconds(), false, send, null);
        this.client.send(request, this.time.milliseconds());
        this.client.poll(1L, this.time.milliseconds());
    }

    @Test
    public void testSimpleRequestResponse() {
        this.checkSimpleRequestResponse(this.client);
    }

    @Test
    public void testSimpleRequestResponseWithStaticNodes() {
        this.checkSimpleRequestResponse(this.clientWithStaticNodes);
    }

    @Test
    public void testClose() {
        this.client.ready(this.node, this.time.milliseconds());
        this.awaitReady(this.client, this.node);
        this.client.poll(1L, this.time.milliseconds());
        Assert.assertTrue((String)"The client should be ready", (boolean)this.client.isReady(this.node, this.time.milliseconds()));
        ProduceRequest produceRequest = new ProduceRequest(1, 1000, Collections.emptyMap());
        RequestHeader reqHeader = this.client.nextRequestHeader(ApiKeys.PRODUCE);
        RequestSend send = new RequestSend(this.node.idString(), reqHeader, produceRequest.toStruct());
        ClientRequest request = new ClientRequest(this.time.milliseconds(), true, send, null);
        this.client.send(request, this.time.milliseconds());
        Assert.assertEquals((String)"There should be 1 in-flight request after send", (long)1L, (long)this.client.inFlightRequestCount(this.node.idString()));
        this.client.close(this.node.idString());
        Assert.assertEquals((String)"There should be no in-flight request after close", (long)0L, (long)this.client.inFlightRequestCount(this.node.idString()));
        Assert.assertFalse((String)"Connection should not be ready after close", (boolean)this.client.isReady(this.node, 0L));
    }

    private void checkSimpleRequestResponse(NetworkClient networkClient) {
        ProduceRequest produceRequest = new ProduceRequest(1, 1000, Collections.emptyMap());
        RequestHeader reqHeader = networkClient.nextRequestHeader(ApiKeys.PRODUCE);
        RequestSend send = new RequestSend(this.node.idString(), reqHeader, produceRequest.toStruct());
        TestCallbackHandler handler = new TestCallbackHandler();
        ClientRequest request = new ClientRequest(this.time.milliseconds(), true, send, (RequestCompletionHandler)handler);
        this.awaitReady(networkClient, this.node);
        networkClient.send(request, this.time.milliseconds());
        networkClient.poll(1L, this.time.milliseconds());
        Assert.assertEquals((long)1L, (long)networkClient.inFlightRequestCount());
        ResponseHeader respHeader = new ResponseHeader(reqHeader.correlationId());
        Struct resp = new Struct(ProtoUtils.currentResponseSchema((int)ApiKeys.PRODUCE.id));
        resp.set("responses", (Object)new Object[0]);
        int size = respHeader.sizeOf() + resp.sizeOf();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        respHeader.writeTo(buffer);
        resp.writeTo(buffer);
        buffer.flip();
        this.selector.completeReceive(new NetworkReceive(this.node.idString(), buffer));
        List responses = networkClient.poll(1L, this.time.milliseconds());
        Assert.assertEquals((long)1L, (long)responses.size());
        Assert.assertTrue((String)"The handler should have executed.", (boolean)handler.executed);
        Assert.assertTrue((String)"Should have a response body.", (boolean)handler.response.hasResponse());
        Assert.assertEquals((String)"Should be correlated to the original request", (Object)request, (Object)handler.response.request());
    }

    private void awaitReady(NetworkClient client, Node node) {
        while (!client.ready(node, this.time.milliseconds())) {
            client.poll(1L, this.time.milliseconds());
        }
    }

    @Test
    public void testRequestTimeout() {
        ProduceRequest produceRequest = new ProduceRequest(1, 1000, Collections.emptyMap());
        RequestHeader reqHeader = this.client.nextRequestHeader(ApiKeys.PRODUCE);
        RequestSend send = new RequestSend(this.node.idString(), reqHeader, produceRequest.toStruct());
        TestCallbackHandler handler = new TestCallbackHandler();
        ClientRequest request = new ClientRequest(this.time.milliseconds(), true, send, (RequestCompletionHandler)handler);
        this.awaitReady(this.client, this.node);
        long now = this.time.milliseconds();
        this.client.send(request, now);
        this.time.sleep(3000L);
        this.client.poll(3000L, this.time.milliseconds());
        String disconnectedNode = this.selector.disconnected().get(0);
        Assert.assertEquals((Object)this.node.idString(), (Object)disconnectedNode);
    }

    @Test
    public void testLeastLoadedNode() {
        Node leastNode = null;
        this.client.ready(this.node, this.time.milliseconds());
        this.awaitReady(this.client, this.node);
        this.client.poll(1L, this.time.milliseconds());
        Assert.assertTrue((String)"The client should be ready", (boolean)this.client.isReady(this.node, this.time.milliseconds()));
        leastNode = this.client.leastLoadedNode(this.time.milliseconds());
        Assert.assertEquals((String)"There should be one leastloadednode", (long)leastNode.id(), (long)this.node.id());
        this.time.sleep(this.reconnectBackoffMsTest);
        this.selector.close(this.node.idString());
        this.client.poll(1L, this.time.milliseconds());
        Assert.assertFalse((String)"After we forced the disconnection the client is no longer ready.", (boolean)this.client.ready(this.node, this.time.milliseconds()));
        leastNode = this.client.leastLoadedNode(this.time.milliseconds());
        Assert.assertEquals((String)"There should be NO leastloadednode", (Object)leastNode, null);
    }

    @Test
    public void testConnectionDelay() {
        long now = this.time.milliseconds();
        long delay = this.client.connectionDelay(this.node, now);
        Assert.assertEquals((long)0L, (long)delay);
    }

    @Test
    public void testConnectionDelayConnected() {
        this.awaitReady(this.client, this.node);
        long now = this.time.milliseconds();
        long delay = this.client.connectionDelay(this.node, now);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)delay);
    }

    @Test
    public void testConnectionDelayDisconnected() {
        this.awaitReady(this.client, this.node);
        this.selector.close(this.node.idString());
        this.client.poll(1000L, this.time.milliseconds());
        long delay = this.client.connectionDelay(this.node, this.time.milliseconds());
        Assert.assertEquals((long)this.reconnectBackoffMsTest, (long)delay);
    }

    private static class TestCallbackHandler
    implements RequestCompletionHandler {
        public boolean executed = false;
        public ClientResponse response;

        private TestCallbackHandler() {
        }

        public void onComplete(ClientResponse response) {
            this.executed = true;
            this.response = response;
        }
    }
}

