/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.timeline;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=3)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class TimelineHashMapBenchmark {
    private static final int NUM_ENTRIES = 1000000;

    @Benchmark
    public Map<Integer, String> testAddEntriesInHashMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>(1000000);
        for (int i = 0; i < 1000000; ++i) {
            int key = (int)(0xFFFFFFFFFFFFFFFFL & (long)i * 2862933555777941757L + 3037000493L);
            map.put(key, String.valueOf(key));
        }
        return map;
    }

    @Benchmark
    public Map<Integer, String> testAddEntriesInTimelineMap() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        TimelineHashMap map = new TimelineHashMap(snapshotRegistry, 1000000);
        for (int i = 0; i < 1000000; ++i) {
            int key = (int)(0xFFFFFFFFFFFFFFFFL & (long)i * 2862933555777941757L + 3037000493L);
            map.put((Object)key, (Object)String.valueOf(key));
        }
        return map;
    }

    @Benchmark
    public Map<Integer, String> testAddEntriesWithSnapshots() {
        SnapshotRegistry snapshotRegistry = new SnapshotRegistry(new LogContext());
        TimelineHashMap map = new TimelineHashMap(snapshotRegistry, 1000000);
        long epoch = 0L;
        int j = 0;
        for (int i = 0; i < 1000000; ++i) {
            int key = (int)(0xFFFFFFFFFFFFFFFFL & (long)i * 2862933555777941757L + 3037000493L);
            if (j > 10 && key % 3 == 0) {
                snapshotRegistry.deleteSnapshotsUpTo(epoch - 1000L);
                snapshotRegistry.createSnapshot(epoch);
                j = 0;
            } else {
                ++j;
            }
            map.put((Object)key, (Object)String.valueOf(key));
            ++epoch;
        }
        return map;
    }
}

