/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.tier;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.log.LogConfig;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTestUtils;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.utils.KafkaScheduler;
import kafka.utils.Scheduler;
import org.apache.kafka.jmh.tier.TierUtils;
import org.mockito.Mockito;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class StateWriteBenchmark {
    private static final int COUNT = 10000;
    private static final String BASE_DIR = System.getProperty("java.io.tmpdir");
    private static final int EPOCH = 0;
    private static final TopicIdPartition TOPIC_PARTITION = new TopicIdPartition("mytopic", UUID.randomUUID(), 0);

    private void writeState(TierPartitionState state) throws IOException {
        state.setTopicId(TOPIC_PARTITION.topicId());
        state.beginCatchup();
        state.append((AbstractTierMetadata)new TierTopicInitLeader(TOPIC_PARTITION, 0, UUID.randomUUID(), 0), TierTestUtils.nextTierTopicOffsetAndEpoch());
        for (int i = 0; i < 10000; ++i) {
            TierUtils.uploadWithMetadata(state, TOPIC_PARTITION, 0, UUID.randomUUID(), i * 2, i * 2 + 1, i, i, false, true, false);
        }
        state.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Benchmark
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void appendReadByteBufferBench() throws Exception {
        LogConfig config = (LogConfig)Mockito.mock(LogConfig.class);
        Mockito.when((Object)config.tierEnable()).thenReturn((Object)true);
        KafkaScheduler scheduler = new KafkaScheduler(0, "tier-partition-state-scheduler-", false);
        scheduler.startup();
        TierPartitionStateFactory factory = new TierPartitionStateFactory(true);
        TierPartitionState state = factory.initState(new File(BASE_DIR), TOPIC_PARTITION.topicPartition(), config, new LogDirFailureChannel(1), (Scheduler)scheduler);
        try {
            this.writeState(state);
        }
        finally {
            scheduler.shutdown();
            state.delete();
        }
    }
}

