/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.tier;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.log.LogConfig;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTestUtils;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.utils.KafkaScheduler;
import kafka.utils.Scheduler;
import org.apache.kafka.jmh.tier.TierUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.Set;

@State(value=Scope.Benchmark)
@Fork(value=4)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class StateMetadataForOffsetBenchmark {
    private static final Random RANDOM = new Random();

    @Benchmark
    @Threads(value=1)
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public Optional<TierObjectMetadata> randomOffsetSeek(DiskState diskState) throws IOException {
        int offset = RANDOM.nextInt(19998);
        return diskState.state.metadata((long)offset);
    }

    @State(value=Scope.Thread)
    public static class DiskState {
        private static final String BASE_DIR = System.getProperty("java.io.tmpdir") + "/" + UUID.randomUUID();
        private static final TopicIdPartition TOPIC_PARTITION = new TopicIdPartition("mytopic", UUID.randomUUID(), 0);
        private static final int EPOCH = 0;
        private static final int COUNT = 10000;
        private TierPartitionStateFactory factory;
        private TierPartitionState state;
        private Scheduler scheduler = new KafkaScheduler(1, "tier-partition-state-scheduler-", true);

        @Setup(value=Level.Trial)
        public void writeState() throws Exception {
            Properties properties = new Properties();
            properties.put(LogConfig.TierEnableProp(), "true");
            LogConfig config = LogConfig.apply((Map)properties, (Set)new HashSet());
            if (!new File(BASE_DIR).mkdir()) {
                throw new Exception("could not create status directory.");
            }
            this.factory = new TierPartitionStateFactory(true);
            this.scheduler.startup();
            this.state = this.factory.initState(new File(BASE_DIR), TOPIC_PARTITION.topicPartition(), config, new LogDirFailureChannel(1), this.scheduler);
            this.state.append((AbstractTierMetadata)new TierTopicInitLeader(TOPIC_PARTITION, 0, UUID.randomUUID(), 0), TierTestUtils.nextTierTopicOffsetAndEpoch());
            for (int i = 0; i < 10000; ++i) {
                TierUtils.uploadWithMetadata(this.state, TOPIC_PARTITION, 0, UUID.randomUUID(), i * 2, i * 2 + 1, i, i, false, true, false);
            }
            this.state.flush();
        }

        @TearDown(value=Level.Trial)
        public void teardown() throws IOException {
            this.scheduler.shutdown();
            this.state.close();
            this.state.delete();
        }
    }
}

