/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.tier;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion$;
import kafka.common.MaybeResolvedTimestampAndOffset;
import kafka.log.AppendOrigin;
import kafka.log.Defaults;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.MergedLog;
import kafka.log.ProducerStateManager;
import kafka.log.TierLogComponents;
import kafka.log.TierLogSegment;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTestUtils;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.utils.KafkaScheduler;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.jmh.tier.TierUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.Set;
import scala.runtime.AbstractFunction0;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class MergedLogTierBenchmark {
    private final TopicPartition topicPartition = new TopicPartition(UUID.randomUUID().toString(), 1);
    private final File logDir = new File(System.getProperty("java.io.tmpdir"), this.topicPartition.toString());
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final KafkaScheduler scheduler = new KafkaScheduler(0, "fake-prefix", false);
    private final BufferSupplier bufferSupplier = BufferSupplier.create();
    private TierPartitionState state;
    private MergedLog mergedLog;
    private static final int NUM_TOTAL_SEGMENTS = 100;
    private static final int NUM_TIERED_SEGMENT = 50;
    private long timestamp = 0L;

    @Setup(value=Level.Trial)
    public void setUp() throws IOException {
        this.scheduler.startup();
        LogConfig logConfig = this.createLogConfig(1000);
        Log log = this.createLog(this.logDir, logConfig);
        TierPartitionStateFactory partitionStateFactory = new TierPartitionStateFactory(true);
        TierLogComponents tierLogComponents = TierLogComponents.apply((Option)Option.empty(), (Option)Option.apply((Object)new MockInMemoryTierObjectStore(TierObjectStoreConfig.createEmpty())), (TierPartitionStateFactory)new TierPartitionStateFactory(true));
        this.state = partitionStateFactory.initState(this.logDir, this.topicPartition, logConfig, new LogDirFailureChannel(1), (Scheduler)this.scheduler);
        this.mergedLog = new MergedLog(log, 0L, this.state, tierLogComponents);
        TopicIdPartition topicIdPartition = new TopicIdPartition(this.topicPartition.topic(), UUID.randomUUID(), this.topicPartition.partition());
        this.state.setTopicId(topicIdPartition.topicId());
        while (log.logSegments().size() < 100) {
            MemoryRecords createRecords = this.buildRecords(0L, this.timestamp, 1, 0L);
            log.appendAsLeader(createRecords, 0, (AppendOrigin)new AppendOrigin.Client$(), ApiVersion$.MODULE$.latestVersion(), this.bufferSupplier);
            ++this.timestamp;
        }
        log.updateHighWatermark(log.logEndOffset());
        this.state.onCatchUpComplete();
        this.state.append((AbstractTierMetadata)new TierTopicInitLeader(topicIdPartition, 0, UUID.randomUUID(), 0), TierTestUtils.nextTierTopicOffsetAndEpoch());
        Collection logSegments = JavaConverters.asJavaCollection((Iterable)log.logSegments());
        logSegments.stream().limit(50L).forEach(segment -> TierUtils.uploadWithMetadata(this.state, topicIdPartition, 0, UUID.randomUUID(), segment.baseOffset(), segment.readNextOffset() - 1L, segment.maxTimestampSoFar(), segment.size(), false, true, false));
        this.state.flush();
        this.mergedLog.deleteOldSegments();
    }

    @TearDown(value=Level.Trial)
    public void tearDown() throws IOException {
        this.scheduler.shutdown();
        this.mergedLog.delete();
        this.state.close();
        this.state.delete();
        this.logDir.delete();
    }

    private LogConfig createLogConfig(int segmentBytes) {
        Properties logProps = new Properties();
        logProps.put(LogConfig.SegmentMsProp(), (Object)Defaults.SegmentMs());
        logProps.put(LogConfig.SegmentBytesProp(), (Object)segmentBytes);
        logProps.put(LogConfig.RetentionMsProp(), "-1");
        logProps.put(LogConfig.RetentionBytesProp(), "-1");
        logProps.put(LogConfig.SegmentJitterMsProp(), (Object)Defaults.SegmentJitterMs());
        logProps.put(LogConfig.CleanupPolicyProp(), Defaults.CleanupPolicy());
        logProps.put(LogConfig.MaxMessageBytesProp(), (Object)Defaults.MaxMessageSize());
        logProps.put(LogConfig.IndexIntervalBytesProp(), (Object)Defaults.IndexInterval());
        logProps.put(LogConfig.SegmentIndexBytesProp(), (Object)Defaults.MaxIndexSize());
        logProps.put(LogConfig.MessageFormatVersionProp(), Defaults.MessageFormatVersion());
        logProps.put(LogConfig.FileDeleteDelayMsProp(), (Object)Defaults.FileDeleteDelayMs());
        logProps.put(LogConfig.TierEnableProp(), "true");
        logProps.put(LogConfig.TierLocalHotsetBytesProp(), "0");
        logProps.put(LogConfig.TierLocalHotsetMsProp(), "0");
        return LogConfig.apply((Map)logProps, (Set)new HashSet());
    }

    private Log createLog(File dir, LogConfig config) {
        TopicPartition topicPartition = Log.parseTopicPartitionName((File)this.logDir);
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, this.logDir, LogManager.ProducerIdExpirationCheckIntervalMs());
        AbstractFunction0<Object> mergedLogStartOffsetCbk = new AbstractFunction0<Object>(){

            public Long apply() {
                return 0L;
            }
        };
        AbstractFunction1<Object, BoxedUnit> mergedLogUpdateStartOffsetCbk = new AbstractFunction1<Object, BoxedUnit>(){

            public BoxedUnit apply(Object v1) {
                return null;
            }
        };
        return new Log(dir, config, 0L, (Scheduler)this.scheduler, this.brokerTopicStats, new Metrics(), Time.SYSTEM, 3600000, LogManager.ProducerIdExpirationCheckIntervalMs(), topicPartition, producerStateManager, null, (Function1)mergedLogUpdateStartOffsetCbk, (Function0)mergedLogStartOffsetCbk, true, true);
    }

    private MemoryRecords buildRecords(long baseOffset, long timestamp, int count, long firstMessageId) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset);
        for (int i = 0; i < count; ++i) {
            builder.append(timestamp, "key".getBytes(), ("value-" + (firstMessageId + (long)i)).getBytes());
        }
        return builder.build();
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void readTier() {
        this.mergedLog.read(25L, 20, (FetchIsolation)FetchHighWatermark$.MODULE$, true, false);
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public long numSegments() {
        return this.mergedLog.numberOfSegments();
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public long size() {
        return this.mergedLog.size();
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public Option<MaybeResolvedTimestampAndOffset> fetchOffsetByTimestamp() {
        return this.mergedLog.fetchOffsetByTimestamp(20L);
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public Object legacyFetchOffsetByTimestamp() {
        return this.mergedLog.legacyFetchOffsetsBefore(20L, 100);
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void tierableLogSegments() {
        this.mergedLog.tierableLogSegments();
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void listSnapshots() {
        ProducerStateManager.listSnapshotFiles((File)this.mergedLog.producerStateManager()._logDir());
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void createUploadableSegment() {
        this.mergedLog.createUploadableSegment((LogSegment)this.mergedLog.tierableLogSegments().head());
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public int tieredLogSegmentsFullIteration() {
        int size = 0;
        Iterator iterator = this.mergedLog.tieredLogSegments();
        while (iterator.hasNext()) {
            size += ((TierLogSegment)iterator.next()).size();
        }
        return size;
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public int tieredLogSegmentsPartialIteration() {
        int partialSize = 0;
        Iterator iterator = this.mergedLog.tieredLogSegments();
        iterator.hasNext();
        partialSize += ((TierLogSegment)iterator.next()).size();
        iterator.hasNext();
        partialSize += ((TierLogSegment)iterator.next()).size();
        iterator.hasNext();
        return partialSize += ((TierLogSegment)iterator.next()).size();
    }
}

