/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.server;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.network.SslUtil;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class SNIHostNameParsingBenchmarking {
    private static final String CLIENT_HELLO = "160303012A010001260303E1DC10EAC2C8DB51B9456C35FC6C44B0BB9C6E1FB0C5EE38707904CBF9728B14000056C02CC02BC030009DC02EC032009F00A3C02F009CC02DC031009E00A2C024C028003DC026C02A006B006AC00AC0140035C005C00F00390038C023C027003CC025C02900670040C009C013002FC004C00E0033003200FF010000A70000000E000C0000096C6F63616C686F7374000500050100000000000A0012001000170018001901000101010201030104000B00020100000D002800260403050306030804080508060809080A080B04010501060104020303030103020203020102020032002800260403050306030804080508060809080A080B04010501060104020303030103020203020102020011000900070200040000000000170000002B00030203030000000000000000";
    private static final ByteBuffer BUFFER = ByteBuffer.allocate(500);

    @Setup(value=Level.Iteration)
    public void setUp() {
        SNIHostNameParsingBenchmarking.fillByteBuffer(CLIENT_HELLO, BUFFER);
        BUFFER.position(0);
    }

    @Benchmark
    public void testExploreParsesExpectedSNIHostName() throws Exception {
        SslUtil.parseSniServerName((ByteBuffer)BUFFER);
    }

    private static void fillByteBuffer(String hexString, ByteBuffer buffer) {
        if (hexString.length() % 2 == 1) {
            throw new IllegalArgumentException("Invalid hexadecimal String supplied.");
        }
        for (int i = 0; i < hexString.length(); i += 2) {
            buffer.put(SNIHostNameParsingBenchmarking.hexToByte(hexString.substring(i, i + 2)));
        }
    }

    private static byte hexToByte(String hexString) {
        int firstDigit = SNIHostNameParsingBenchmarking.toDigit(hexString.charAt(0));
        int secondDigit = SNIHostNameParsingBenchmarking.toDigit(hexString.charAt(1));
        return (byte)((firstDigit << 4) + secondDigit);
    }

    private static int toDigit(char hexChar) {
        int digit = Character.digit(hexChar, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Invalid Hexadecimal Character: " + hexChar);
        }
        return digit;
    }
}

