/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.server;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kafka.cluster.Partition;
import kafka.log.CleanerConfig;
import kafka.log.Defaults;
import kafka.log.LogConfig;
import kafka.log.LogManager;
import kafka.log.TierLogComponents;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.TierReplicaComponents;
import kafka.server.ZkMetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.CachedConfigRepository;
import kafka.server.metadata.ConfigRepository;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.utils.KafkaScheduler;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.Set;

@Warmup(iterations=5)
@Measurement(iterations=5)
@Fork(value=3)
@BenchmarkMode(value={Mode.AverageTime})
@State(value=Scope.Benchmark)
public class PartitionCreationBench {
    @Param(value={"false", "true"})
    public boolean useTopicIds;
    @Param(value={"false", "true"})
    public boolean tiered;
    @Param(value={"2000"})
    public int numPartitions;
    private final String topicName = "foo";
    private Option<Uuid> topicId;
    private Scheduler scheduler;
    private Metrics metrics;
    private Time time;
    private KafkaConfig brokerProperties;
    private ReplicaManager replicaManager;
    private QuotaFactory.QuotaManagers quotaManagers;
    private LogDirFailureChannel failureChannel;
    private LogManager logManager;
    private AlterIsrManager alterIsrManager;
    private List<TopicPartition> topicPartitions;

    @Setup(value=Level.Invocation)
    public void setup() {
        this.topicId = this.useTopicIds ? Option.apply((Object)Uuid.randomUuid()) : Option.empty();
        this.scheduler = new KafkaScheduler(1, "scheduler-thread", true);
        this.brokerProperties = KafkaConfig.fromProps((Properties)TestUtils.createBrokerConfig((int)0, (String)TestUtils.MockZkConnect(), (boolean)true, (boolean)true, (int)9092, (Option)Option.empty(), (Option)Option.empty(), (Option)Option.empty(), (boolean)true, (boolean)false, (int)0, (boolean)false, (int)0, (boolean)false, (int)0, (Option)Option.empty(), (int)1, (boolean)true, (int)1, (short)1));
        this.metrics = new Metrics();
        this.time = Time.SYSTEM;
        this.failureChannel = new LogDirFailureChannel(this.brokerProperties.logDirs().size());
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        List files = JavaConverters.seqAsJavaList((Seq)this.brokerProperties.logDirs()).stream().map(File::new).collect(Collectors.toList());
        CleanerConfig cleanerConfig = CleanerConfig.apply((int)1, (long)0x400000L, (double)0.9, (int)0x100000, (int)0x2000000, (double)Double.MAX_VALUE, (long)15000L, (boolean)true, (int)Integer.MAX_VALUE, (String)"MD5");
        TierLogComponents tierLogComponents = this.tiered ? TierLogComponents.apply((Option)Option.empty(), (Option)Option.apply((Object)new MockInMemoryTierObjectStore(TierObjectStoreConfig.createEmpty())), (TierPartitionStateFactory)new TierPartitionStateFactory(true)) : TierLogComponents.EMPTY();
        CachedConfigRepository configRepository = TestUtils.createConfigRepository((String)"foo", (Properties)new Properties());
        this.logManager = new LogManager((Seq)((Iterator)JavaConverters.asScalaIteratorConverter(files.iterator()).asScala()).toSeq(), (Seq)((Iterator)JavaConverters.asScalaIteratorConverter(new ArrayList().iterator()).asScala()).toSeq(), (ConfigRepository)configRepository, PartitionCreationBench.createLogConfig(this.tiered), cleanerConfig, 1, 1000L, 10000L, 10000L, 1000, 1000L, Integer.MAX_VALUE, 60000, this.scheduler, brokerTopicStats, this.metrics, this.failureChannel, tierLogComponents, Time.SYSTEM, true);
        this.scheduler.startup();
        ZkMetadataCache metadataCache = new ZkMetadataCache(this.brokerProperties.brokerId(), false);
        this.quotaManagers = QuotaFactory.instantiate((KafkaConfig)this.brokerProperties, (Metrics)this.metrics, (Time)this.time, (String)"");
        KafkaZkClient zkClient = new KafkaZkClient(null, false, Time.SYSTEM){

            public Properties getEntityConfigs(String rootEntityType, String sanitizedEntityName) {
                return new Properties();
            }
        };
        this.alterIsrManager = TestUtils.createAlterIsrManager();
        this.replicaManager = new ReplicaManager(this.brokerProperties, this.metrics, this.time, Option.apply((Object)zkClient), this.scheduler, this.logManager, new AtomicBoolean(false), this.quotaManagers, brokerTopicStats, (MetadataCache)metadataCache, this.failureChannel, TierReplicaComponents.EMPTY(), Option.empty(), this.alterIsrManager, (ConfigRepository)configRepository, Option.empty());
        this.replicaManager.startup();
        this.replicaManager.checkpointHighWatermarks();
    }

    @TearDown(value=Level.Invocation)
    public void tearDown() throws Exception {
        this.replicaManager.shutdown(false);
        this.logManager.shutdown();
        this.metrics.close();
        this.scheduler.shutdown();
        this.quotaManagers.shutdown();
        for (File dir : JavaConverters.asJavaCollection((Iterable)this.logManager.liveLogDirs())) {
            Utils.delete((File)dir);
        }
    }

    private static LogConfig createLogConfig(Boolean tiered) {
        Properties logProps = new Properties();
        logProps.put(LogConfig.SegmentMsProp(), (Object)Defaults.SegmentMs());
        logProps.put(LogConfig.SegmentBytesProp(), (Object)Defaults.SegmentSize());
        logProps.put(LogConfig.RetentionMsProp(), (Object)Defaults.RetentionMs());
        logProps.put(LogConfig.RetentionBytesProp(), (Object)Defaults.RetentionSize());
        logProps.put(LogConfig.SegmentJitterMsProp(), (Object)Defaults.SegmentJitterMs());
        logProps.put(LogConfig.CleanupPolicyProp(), Defaults.CleanupPolicy());
        logProps.put(LogConfig.MaxMessageBytesProp(), (Object)Defaults.MaxMessageSize());
        logProps.put(LogConfig.IndexIntervalBytesProp(), (Object)Defaults.IndexInterval());
        logProps.put(LogConfig.SegmentIndexBytesProp(), (Object)Defaults.MaxIndexSize());
        logProps.put(LogConfig.MessageFormatVersionProp(), Defaults.MessageFormatVersion());
        logProps.put(LogConfig.FileDeleteDelayMsProp(), (Object)Defaults.FileDeleteDelayMs());
        logProps.put(LogConfig.TierEnableProp(), tiered.toString());
        return LogConfig.apply((Map)logProps, (Set)new HashSet());
    }

    @Benchmark
    @Threads(value=1)
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    public void makeFollower() {
        this.topicPartitions = new ArrayList<TopicPartition>();
        for (int partitionNum = 0; partitionNum < this.numPartitions; ++partitionNum) {
            this.topicPartitions.add(new TopicPartition("foo", partitionNum));
        }
        ArrayList<Integer> replicas = new ArrayList<Integer>();
        replicas.add(0);
        replicas.add(1);
        replicas.add(2);
        OffsetCheckpoints checkpoints = (logDir, topicPartition) -> Option.apply((Object)0L);
        for (TopicPartition topicPartition2 : this.topicPartitions) {
            Partition partition = this.replicaManager.createPartition(topicPartition2);
            ArrayList<Integer> inSync = new ArrayList<Integer>();
            inSync.add(0);
            inSync.add(1);
            inSync.add(2);
            LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(inSync).setZkVersion(1).setReplicas(replicas).setIsNew(true);
            this.topicId.foreach(arg_0 -> ((LeaderAndIsrRequestData.LeaderAndIsrPartitionState)partitionState).setTopicId(arg_0));
            partition.makeFollower(partitionState, checkpoints);
            this.topicId.foreach(arg_0 -> ((Partition)partition).checkOrSetTopicId(arg_0));
        }
    }
}

