/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslConfigEntry;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecrets;
import io.confluent.kafka.server.plugins.auth.MultiTenantSaslSecretsLoader;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.test.TestUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Warmup(iterations=4)
@Measurement(iterations=4)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
public class MultiTenantSaslSecretsLoaderBench {
    private static final int NUM_JSON_ENTRIES = 100;
    private File jsonFile;
    private MultiTenantSaslSecretsLoader loader;

    private static String randomAlphabeticalString(Random random, int length) {
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = (byte)(97 + random.nextInt(26));
        }
        return new String(array, StandardCharsets.UTF_8);
    }

    private static MultiTenantSaslConfigEntry randomEntry(Random random) {
        return new MultiTenantSaslConfigEntry("PLAIN", MultiTenantSaslSecretsLoaderBench.randomAlphabeticalString(random, 12), "myhash", MultiTenantSaslSecretsLoaderBench.randomAlphabeticalString(random, 16), MultiTenantSaslSecretsLoaderBench.randomAlphabeticalString(random, 8), true);
    }

    @Setup(value=Level.Trial)
    public void setup() throws Exception {
        Random random = new Random(123L);
        HashMap<String, MultiTenantSaslConfigEntry> entries = new HashMap<String, MultiTenantSaslConfigEntry>();
        for (int i = 0; i < 100; ++i) {
            String key;
            while (entries.containsKey(key = MultiTenantSaslSecretsLoaderBench.randomAlphabeticalString(random, 10))) {
            }
            entries.put(key, MultiTenantSaslSecretsLoaderBench.randomEntry(random));
        }
        MultiTenantSaslSecrets secrets = new MultiTenantSaslSecrets(entries);
        ObjectMapper objectMapper = new ObjectMapper();
        this.jsonFile = TestUtils.tempFile((String)new String(objectMapper.writeValueAsBytes((Object)secrets), StandardCharsets.UTF_8));
        this.loader = new MultiTenantSaslSecretsLoader(3);
    }

    @TearDown(value=Level.Trial)
    public void tearDown() throws Exception {
        Files.deleteIfExists(this.jsonFile.toPath());
        this.loader = null;
    }

    @Benchmark
    @Threads(value=1)
    public MultiTenantSaslSecrets measureJsonReloadTime() {
        return this.loader.load(this.jsonFile.getAbsolutePath(), 0L, 0L);
    }

    @Benchmark
    @Threads(value=1)
    public MultiTenantSaslSecrets measureCachedAccessTime() {
        return this.loader.load(this.jsonFile.getAbsolutePath(), 0L, 100L);
    }
}

