/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.server;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.Defaults;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottler$;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.QuotaType;
import kafka.utils.MockTime;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.compat.java8.OptionConverters;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class DiskUsageBasedThrottlerBench {
    private Path logDir;
    private Map<Boolean, ClientQuotaManager> quotaManagerMap;
    private final Time mockTime = new MockTime();
    private final long pollFrequency = 42L;

    @Setup(value=Level.Trial)
    public void setup() throws IOException {
        this.quotaManagerMap = new HashMap<Boolean, ClientQuotaManager>(2);
        this.logDir = Files.createTempDirectory(UUID.randomUUID().toString(), new FileAttribute[0]);
        if (!Files.isDirectory(this.logDir, new LinkOption[0])) {
            throw new IOException("error creating test directory");
        }
        ArrayList<String> fileStores = new ArrayList<String>(){
            {
                this.add(DiskUsageBasedThrottlerBench.this.logDir.toString());
            }
        };
        boolean produceBackpressureEnabled = false;
        ClientQuotaManagerConfig activeQuotaManagerConfig = new ClientQuotaManagerConfig(Defaults.QuotaBytesPerSecond(), Defaults.DefaultNumQuotaSamples(), Defaults.DefaultQuotaWindowSizeSeconds(), new BrokerBackpressureConfig(false, 42L, (Seq)((Iterator)JavaConverters.asScalaIteratorConverter(new ArrayList().iterator()).asScala()).toSeq(), Double.MAX_VALUE, (double)ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT.longValue(), "p95"), DiskUsageBasedThrottlingConfig.apply((long)Long.MAX_VALUE, (long)131072L, (Seq)((Iterator)JavaConverters.asScalaIteratorConverter(fileStores.iterator()).asScala()).toSeq(), (boolean)true, (long)42L, (double)1.5, (boolean)false));
        ClientQuotaManagerConfig inactiveQuotaManagerConfig = new ClientQuotaManagerConfig(Defaults.QuotaBytesPerSecond(), Defaults.DefaultNumQuotaSamples(), Defaults.DefaultQuotaWindowSizeSeconds(), new BrokerBackpressureConfig(false, 42L, (Seq)((Iterator)JavaConverters.asScalaIteratorConverter(new ArrayList().iterator()).asScala()).toSeq(), Double.MAX_VALUE, (double)ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT.longValue(), "p95"), DiskUsageBasedThrottlingConfig.apply((long)Long.MAX_VALUE, (long)131072L, (Seq)((Iterator)JavaConverters.asScalaIteratorConverter(fileStores.iterator()).asScala()).toSeq(), (boolean)false, (long)42L, (double)1.5, (boolean)false));
        ClientQuotaManager activeQuotaManager = new ClientQuotaManager(activeQuotaManagerConfig, new Metrics(), (QuotaType)QuotaType.Produce$.MODULE$, this.mockTime, "someThread", OptionConverters.toScala(Optional.empty()), OptionConverters.toScala(Optional.empty()));
        this.quotaManagerMap.put(true, activeQuotaManager);
        ClientQuotaManager inactiveQuotaManager = new ClientQuotaManager(inactiveQuotaManagerConfig, new Metrics(), (QuotaType)QuotaType.Produce$.MODULE$, this.mockTime, "someThread", OptionConverters.toScala(Optional.empty()), OptionConverters.toScala(Optional.empty()));
        this.quotaManagerMap.put(false, inactiveQuotaManager);
        this.quotaManagerMap.values().forEach(arg_0 -> ((DiskUsageBasedThrottler$)DiskUsageBasedThrottler$.MODULE$).registerListener(arg_0));
    }

    @TearDown(value=Level.Trial)
    public void tearDown() throws IOException {
        this.quotaManagerMap.values().forEach(quotaManager -> {
            quotaManager.shutdown();
            DiskUsageBasedThrottler$.MODULE$.deRegisterListener((DiskUsageBasedThrottleListener)quotaManager);
        });
        Files.deleteIfExists(this.logDir);
    }

    @Benchmark
    public void testWithDiskThrottlingEnabled() {
        this.mockTime.sleep(43L);
        this.quotaManagerMap.get(true).checkAndUpdateQuotaOnDiskUsage(this.mockTime.milliseconds());
    }

    @Benchmark
    public void testWithDiskThrottlingDisabled() {
        this.mockTime.sleep(43L);
        this.quotaManagerMap.get(false).checkAndUpdateQuotaOnDiskUsage(this.mockTime.milliseconds());
    }
}

