/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.server;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.quota.QuotaConfig;
import io.confluent.kafka.multitenant.quota.TenantQuotaCallback;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import kafka.network.RequestChannel;
import kafka.server.ActiveTenantsManager;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.Defaults;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.QuotaType;
import kafka.utils.TestUtils;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.compat.java8.OptionConverters;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class ClientQuotaBackpressureBench {
    private final TenantQuotaCallback quotaCallback = new TenantQuotaCallback();
    private final QuotaType quotaType = QuotaType.Produce$.MODULE$;
    private final Time mockTime = new MockTime();
    private ActiveTenantsManager activeTenantsManager;
    private ClientQuotaManager clientQuotaManager;
    private Metrics metrics;
    private final long produceQuota = 10000000L;
    private final long backpressureBrokerLimit = 100000000L;
    @Param(value={"50", "200", "1000"})
    private int numTenants;
    @Param(value={"false", "true"})
    private boolean backpressureEnabled;

    @Setup(value=Level.Trial)
    public void setup() {
        ClientQuotaManagerConfig quotaManagerConfig = new ClientQuotaManagerConfig(Defaults.QuotaBytesPerSecond(), Defaults.DefaultNumQuotaSamples(), Defaults.DefaultQuotaWindowSizeSeconds(), new BrokerBackpressureConfig(true, 0L, (Seq)((Iterator)JavaConverters.asScalaIteratorConverter(Collections.emptyIterator()).asScala()).toSeq(), Double.MAX_VALUE, (double)ConfluentConfigs.BACKPRESSURE_REQUEST_MIN_BROKER_LIMIT_DEFAULT.longValue(), "p95"), DiskUsageBasedThrottlingConfig.apply((long)Long.MAX_VALUE, (long)131072L, (Seq)((Iterator)JavaConverters.asScalaIteratorConverter(Collections.emptyIterator()).asScala()).toSeq(), (boolean)false, (long)0L, (double)1.5, (boolean)false));
        this.quotaCallback.configure(Collections.singletonMap("broker.id", 1));
        TenantQuotaCallback.updateQuotas(Collections.emptyMap(), (QuotaConfig)new QuotaConfig(Long.valueOf(10000000L), Long.valueOf(Long.MAX_VALUE), Double.valueOf(Double.MAX_VALUE), Double.valueOf(Double.MAX_VALUE), QuotaConfig.UNLIMITED_QUOTA));
        this.metrics = new Metrics();
        this.activeTenantsManager = new ActiveTenantsManager(this.metrics, this.mockTime, BrokerBackpressureConfig.DefaultActiveWindowMs());
        this.clientQuotaManager = new ClientQuotaManager(quotaManagerConfig, this.metrics, this.quotaType, this.mockTime, "some-prefix", OptionConverters.toScala(Optional.of(this.quotaCallback)), OptionConverters.toScala(Optional.of(this.activeTenantsManager)));
        IntStream.range(0, this.numTenants).forEach(i -> this.addTenant());
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        this.clientQuotaManager.shutdown();
    }

    private void addTenant() {
        String tenant = "lkc-" + TestUtils.randomString((int)5);
        MultiTenantPrincipal principal = new MultiTenantPrincipal("user", new TenantMetadata(tenant, "pkc-blah"));
        RequestChannel.Session session = new RequestChannel.Session((KafkaPrincipal)principal, null);
        long produce = ThreadLocalRandom.current().nextLong(2500000L, 5000000L);
        this.clientQuotaManager.recordAndGetThrottleTimeMs(session, "user", (double)produce, this.mockTime.milliseconds());
        if (this.backpressureEnabled) {
            this.clientQuotaManager.setBrokerQuotaLimit(1.0E8);
        }
    }

    @Benchmark
    public void maybeAutoTuneQuota() {
        this.clientQuotaManager.maybeAutoTuneQuota(this.activeTenantsManager, this.mockTime.milliseconds());
    }
}

