/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.server;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kafka.cluster.Partition;
import kafka.log.CleanerConfig;
import kafka.log.LogConfig;
import kafka.log.LogManager;
import kafka.log.TierLogComponents;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.TierReplicaComponents;
import kafka.server.ZkMetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.CachedConfigRepository;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Seq;

@Warmup(iterations=5)
@Measurement(iterations=5)
@Fork(value=3)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
public class CheckpointBench {
    @Param(value={"100", "1000", "2000"})
    public int numTopics;
    @Param(value={"3"})
    public int numPartitions;
    private final String topicName = "foo";
    private Scheduler scheduler;
    private Metrics metrics;
    private MockTime time;
    private KafkaConfig brokerProperties;
    private ReplicaManager replicaManager;
    private QuotaFactory.QuotaManagers quotaManagers;
    private LogDirFailureChannel failureChannel;
    private LogManager logManager;
    private AlterIsrManager alterIsrManager;
    private final CachedConfigRepository configRepository = new CachedConfigRepository();

    @Setup(value=Level.Trial)
    public void setup() {
        this.scheduler = new KafkaScheduler(1, "scheduler-thread", true);
        this.brokerProperties = KafkaConfig.fromProps((Properties)TestUtils.createBrokerConfig((int)0, (String)TestUtils.MockZkConnect(), (boolean)true, (boolean)true, (int)9092, (Option)Option.empty(), (Option)Option.empty(), (Option)Option.empty(), (boolean)true, (boolean)false, (int)0, (boolean)false, (int)0, (boolean)false, (int)0, (Option)Option.empty(), (int)1, (boolean)true, (int)1, (short)1));
        this.metrics = new Metrics();
        this.time = new MockTime();
        this.failureChannel = new LogDirFailureChannel(this.brokerProperties.logDirs().size());
        List files = JavaConverters.seqAsJavaList((Seq)this.brokerProperties.logDirs()).stream().map(File::new).collect(Collectors.toList());
        this.logManager = TestUtils.createLogManager((Seq)JavaConverters.asScalaBuffer(files), (LogConfig)LogConfig.apply(), (ConfigRepository)new CachedConfigRepository(), (CleanerConfig)CleanerConfig.apply((int)1, (long)0x400000L, (double)0.9, (int)0x100000, (int)0x2000000, (double)Double.MAX_VALUE, (long)15000L, (boolean)true, (int)Integer.MAX_VALUE, (String)"MD5"), (MockTime)this.time, (TierLogComponents)TierLogComponents.EMPTY());
        this.scheduler.startup();
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        ZkMetadataCache metadataCache = MetadataCache.zkMetadataCache((int)this.brokerProperties.brokerId(), (boolean)false);
        this.quotaManagers = QuotaFactory.instantiate((KafkaConfig)this.brokerProperties, (Metrics)this.metrics, (Time)this.time, (String)"");
        this.alterIsrManager = TestUtils.createAlterIsrManager();
        this.replicaManager = new ReplicaManager(this.brokerProperties, this.metrics, (Time)this.time, Option.empty(), this.scheduler, this.logManager, new AtomicBoolean(false), this.quotaManagers, brokerTopicStats, (MetadataCache)metadataCache, this.failureChannel, TierReplicaComponents.EMPTY(), Option.empty(), this.alterIsrManager, (ConfigRepository)this.configRepository, Option.empty());
        this.replicaManager.startup();
        ArrayList<TopicPartition> topicPartitions = new ArrayList<TopicPartition>();
        for (int topicNum = 0; topicNum < this.numTopics; ++topicNum) {
            String topicName = this.topicName + "-" + topicNum;
            for (int partitionNum = 0; partitionNum < this.numPartitions; ++partitionNum) {
                topicPartitions.add(new TopicPartition(topicName, partitionNum));
            }
        }
        OffsetCheckpoints checkpoints = (logDir, topicPartition) -> Option.apply((Object)0L);
        for (TopicPartition topicPartition2 : topicPartitions) {
            Partition partition = this.replicaManager.createPartition(topicPartition2);
            partition.createLogIfNotExists(true, false, checkpoints);
        }
        this.replicaManager.checkpointHighWatermarks();
    }

    @TearDown(value=Level.Trial)
    public void tearDown() throws Exception {
        this.replicaManager.shutdown(false);
        this.metrics.close();
        this.scheduler.shutdown();
        this.quotaManagers.shutdown();
        for (File dir : JavaConverters.asJavaCollection((Iterable)this.logManager.liveLogDirs())) {
            Utils.delete((File)dir);
        }
    }

    @Benchmark
    @Threads(value=1)
    public void measureCheckpointHighWatermarks() {
        this.replicaManager.checkpointHighWatermarks();
    }

    @Benchmark
    @Threads(value=1)
    public void measureCheckpointLogStartOffsets() {
        this.logManager.checkpointLogStartOffsets();
    }
}

