/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.server;

import io.confluent.kafka.server.plugins.auth.AuthAttemptCache;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Warmup(iterations=4)
@Measurement(iterations=4)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
public class AuthAttemptCacheBench {
    private static final int MAX_ENTRIES = 10000000;
    private MockTime time;
    private AuthAttemptCache cache;
    private Random random;

    @Setup(value=Level.Iteration)
    public void setup() throws Exception {
        this.time = new MockTime(0L, 1000L, 1L);
        this.cache = new AuthAttemptCache(10000001L, 10000000, (Time)this.time, 10);
        this.random = new Random(123L);
        for (int i = 0; i < 10000000; ++i) {
            this.cache.put(Integer.toString(i), "password" + i, "hash" + i);
            this.time.sleep(1L);
        }
    }

    @TearDown(value=Level.Iteration)
    public void tearDown() throws Exception {
        this.cache = null;
        this.random = null;
    }

    @Benchmark
    @Threads(value=1)
    public String measureCacheAccessTime() {
        String username = Integer.toString(this.random.nextInt(10000000));
        String password = "password" + username;
        return this.cache.get(username, password);
    }

    @Benchmark
    @Threads(value=1)
    public String measureCacheAccessAndRemovalTime() {
        String username = Integer.toString(this.random.nextInt(10000000));
        this.time.sleep(1L);
        String password = "password" + username;
        return this.cache.get(username, password);
    }
}

