/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import kafka.api.ApiVersion;
import kafka.common.LongRef;
import kafka.log.AppendOrigin;
import kafka.log.InterceptorStats;
import kafka.log.LogValidator;
import kafka.message.CompressionCodec;
import kafka.server.BrokerTopicStats;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.jmh.record.BaseRecordBatchBenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;
import scala.collection.Iterable;
import scala.collection.JavaConverters;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
public class RecordBatchIterationBenchmark
extends BaseRecordBatchBenchmark {
    @Param(value={"LZ4", "SNAPPY", "GZIP", "NONE"})
    private CompressionType compressionType = CompressionType.NONE;
    @Param(value={"1", "2"})
    byte messageVersion = (byte)2;

    @Override
    CompressionType compressionType() {
        return this.compressionType;
    }

    @Override
    byte messageVersion() {
        return this.messageVersion;
    }

    @Benchmark
    public void measureValidation(Blackhole bh) throws IOException {
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.singleBatchBuffer.duplicate());
        LogValidator.validateMessagesAndAssignOffsetsCompressed((MemoryRecords)records, (TopicPartition)new TopicPartition("a", 0), (LongRef)new LongRef((long)this.startingOffset), (Time)Time.SYSTEM, (long)System.currentTimeMillis(), (CompressionCodec)CompressionCodec.getCompressionCodec((int)this.compressionType.id), (CompressionCodec)CompressionCodec.getCompressionCodec((int)this.compressionType.id), (boolean)false, (byte)this.messageVersion, (TimestampType)TimestampType.CREATE_TIME, (long)Long.MAX_VALUE, (int)0, (AppendOrigin)new AppendOrigin.Client$(), (ApiVersion)ApiVersion.latestVersion(), (Iterable)JavaConverters.iterableAsScalaIterable(new ArrayList()), (InterceptorStats)this.interceptorStats, (BrokerTopicStats)this.brokerTopicStats, (BufferSupplier)this.bufferSupplier);
    }

    @Benchmark
    public void measureIteratorForBatchWithSingleMessage(Blackhole bh) throws IOException {
        for (RecordBatch batch : MemoryRecords.readableRecords((ByteBuffer)this.singleBatchBuffer.duplicate()).batches()) {
            CloseableIterator iterator = batch.streamingIterator(this.bufferSupplier);
            Throwable throwable = null;
            try {
                while (iterator.hasNext()) {
                    bh.consume(iterator.next());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (iterator == null) continue;
                if (throwable != null) {
                    try {
                        iterator.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                iterator.close();
            }
        }
    }

    @OperationsPerInvocation(value=100)
    @Fork(jvmArgsAppend={"-Xmx8g"})
    @Benchmark
    public void measureStreamingIteratorForVariableBatchSize(Blackhole bh) throws IOException {
        for (int i = 0; i < 100; ++i) {
            for (RecordBatch batch : MemoryRecords.readableRecords((ByteBuffer)this.batchBuffers[i].duplicate()).batches()) {
                CloseableIterator iterator = batch.streamingIterator(this.bufferSupplier);
                Throwable throwable = null;
                try {
                    while (iterator.hasNext()) {
                        bh.consume(iterator.next());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iterator == null) continue;
                    if (throwable != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iterator.close();
                }
            }
        }
    }

    @OperationsPerInvocation(value=100)
    @Fork(jvmArgsAppend={"-Xmx8g"})
    @Benchmark
    public void measureSkipIteratorForVariableBatchSize(Blackhole bh) throws IOException {
        for (int i = 0; i < 100; ++i) {
            for (MutableRecordBatch batch : MemoryRecords.readableRecords((ByteBuffer)this.batchBuffers[i].duplicate()).batches()) {
                CloseableIterator iterator = batch.skipKeyValueIterator(this.bufferSupplier);
                Throwable throwable = null;
                try {
                    while (iterator.hasNext()) {
                        bh.consume(iterator.next());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iterator == null) continue;
                    if (throwable != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iterator.close();
                }
            }
        }
    }
}

