/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.record;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import kafka.log.InterceptorStats;
import kafka.server.BrokerTopicStats;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Benchmark)
public abstract class BaseRecordBatchBenchmark {
    private static final int MAX_HEADER_SIZE = 5;
    private static final int HEADER_KEY_SIZE = 30;
    private final Random random = new Random(0L);
    final int batchCount = 100;
    @Param(value={"1", "2", "50"})
    private int maxBatchSize = 1;
    @Param(value={"100", "100000"})
    private int messageSize = 100;
    @Param(value={"RANDOM"})
    private Bytes bytes = Bytes.RANDOM;
    @Param(value={"NO_CACHING", "CREATE"})
    private String bufferSupplierStr = "NO_CACHING";
    int startingOffset;
    ByteBuffer singleBatchBuffer;
    ByteBuffer[] batchBuffers;
    BufferSupplier bufferSupplier;
    final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    final InterceptorStats interceptorStats = new InterceptorStats();

    @Setup
    public void init() {
        int n = this.startingOffset = this.messageVersion() == 2 ? 0 : 42;
        if (this.bufferSupplierStr.equals("NO_CACHING")) {
            this.bufferSupplier = BufferSupplier.NO_CACHING;
        } else if (this.bufferSupplierStr.equals("CREATE")) {
            this.bufferSupplier = BufferSupplier.create();
        } else {
            throw new IllegalArgumentException("Unsupported buffer supplier " + this.bufferSupplierStr);
        }
        this.singleBatchBuffer = this.createBatch(1);
        this.batchBuffers = new ByteBuffer[100];
        for (int i = 0; i < 100; ++i) {
            int size = this.random.nextInt(this.maxBatchSize) + 1;
            this.batchBuffers[i] = this.createBatch(size);
        }
    }

    private static Header[] createHeaders() {
        char[] headerChars = new char[30];
        Arrays.fill(headerChars, 'a');
        final String headerKey = new String(headerChars);
        final byte[] headerValue = new byte[]{};
        return (Header[])IntStream.range(0, 5).mapToObj(index -> new Header(){

            public String key() {
                return headerKey;
            }

            public byte[] value() {
                return headerValue;
            }
        }).toArray(Header[]::new);
    }

    abstract CompressionType compressionType();

    abstract byte messageVersion();

    private ByteBuffer createBatch(int batchSize) {
        Header[] headers = this.messageVersion() < 2 ? Record.EMPTY_HEADERS : BaseRecordBatchBenchmark.createHeaders();
        byte[] value = new byte[this.messageSize];
        ByteBuffer buf = ByteBuffer.allocate(AbstractRecords.estimateSizeInBytesUpperBound((byte)this.messageVersion(), (CompressionType)this.compressionType(), (byte[])new byte[0], (byte[])value, (Header[])headers) * batchSize);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)this.messageVersion(), (CompressionType)this.compressionType(), (TimestampType)TimestampType.CREATE_TIME, (long)this.startingOffset);
        for (int i = 0; i < batchSize; ++i) {
            switch (this.bytes) {
                case ONES: {
                    Arrays.fill(value, (byte)1);
                    break;
                }
                case RANDOM: {
                    this.random.nextBytes(value);
                }
            }
            builder.append(0L, null, value, headers);
        }
        return builder.build().buffer();
    }

    public static enum Bytes {
        RANDOM,
        ONES;

    }
}

