/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.producer;

import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ProduceResponse;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class ProducerResponseBenchmark {
    private static final int NUMBER_OF_PARTITIONS = 3;
    private static final int NUMBER_OF_RECORDS = 3;
    private static final Map<TopicPartition, ProduceResponse.PartitionResponse> PARTITION_RESPONSE_MAP = IntStream.range(0, 3).mapToObj(partitionIndex -> new AbstractMap.SimpleEntry<TopicPartition, ProduceResponse.PartitionResponse>(new TopicPartition("tp", partitionIndex), new ProduceResponse.PartitionResponse(Errors.NONE, 0L, 0L, 0L, IntStream.range(0, 3).mapToObj(ProduceResponse.RecordError::new).collect(Collectors.toList())))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    private static final ProduceResponse RESPONSE = ProducerResponseBenchmark.response();

    private static ProduceResponse response() {
        return new ProduceResponse(PARTITION_RESPONSE_MAP);
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public AbstractResponse constructorProduceResponse() {
        return ProducerResponseBenchmark.response();
    }
}

