/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.producer;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class ProducerRequestBenchmark {
    private static final int NUMBER_OF_PARTITIONS = 3;
    private static final int NUMBER_OF_RECORDS = 3;
    private static final List<ProduceRequestData.TopicProduceData> TOPIC_PRODUCE_DATA = Collections.singletonList(new ProduceRequestData.TopicProduceData().setName("tp").setPartitionData(IntStream.range(0, 3).mapToObj(partitionIndex -> new ProduceRequestData.PartitionProduceData().setIndex(partitionIndex).setRecords((BaseRecords)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])IntStream.range(0, 3).mapToObj(recordIndex -> new SimpleRecord(100L, "hello0".getBytes(StandardCharsets.UTF_8))).collect(Collectors.toList()).toArray(new SimpleRecord[0])))).collect(Collectors.toList())));
    private static final ProduceRequestData PRODUCE_REQUEST_DATA = new ProduceRequestData().setTimeoutMs(100).setAcks((short)1).setTopicData(new ProduceRequestData.TopicProduceDataCollection(TOPIC_PRODUCE_DATA.iterator()));
    private static final ProduceRequest REQUEST = ProducerRequestBenchmark.request();

    private static ProduceRequest request() {
        return (ProduceRequest)ProduceRequest.forMagic((byte)2, (ProduceRequestData)PRODUCE_REQUEST_DATA).build();
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public ProduceRequest constructorProduceRequest() {
        return ProducerRequestBenchmark.request();
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public ProduceResponse constructorErrorResponse() {
        return REQUEST.getErrorResponse(0, (Throwable)Errors.INVALID_REQUEST.exception());
    }
}

