/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.partition;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion$;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.Partition;
import kafka.log.CleanerConfig;
import kafka.log.Defaults;
import kafka.log.LogConfig;
import kafka.log.LogManager;
import kafka.log.TierLogComponents;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.CachedConfigRepository;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.KafkaScheduler;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.mockito.Mockito;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.Set;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class UpdateFollowerFetchStateBenchmark {
    private TopicPartition topicPartition = new TopicPartition(UUID.randomUUID().toString(), 0);
    private File logDir = new File(System.getProperty("java.io.tmpdir"), this.topicPartition.toString());
    private KafkaScheduler scheduler = new KafkaScheduler(1, "scheduler", true);
    private BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private LogDirFailureChannel logDirFailureChannel = (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class);
    private long nextOffset = 0L;
    private LogManager logManager;
    private Partition partition;

    @Setup(value=Level.Trial)
    public void setUp() {
        this.scheduler.startup();
        LogConfig logConfig = this.createLogConfig();
        List<File> logDirs = Collections.singletonList(this.logDir);
        this.logManager = new LogManager((Seq)((Iterator)JavaConverters.asScalaIteratorConverter(logDirs.iterator()).asScala()).toSeq(), (Seq)((Iterator)JavaConverters.asScalaIteratorConverter(new ArrayList().iterator()).asScala()).toSeq(), (ConfigRepository)new CachedConfigRepository(), logConfig, new CleanerConfig(0, 0L, 0.0, 0, 0, 0.0, 0L, false, Integer.MAX_VALUE, "MD5"), 1, 1000L, 10000L, 10000L, 10000, 1000L, Integer.MAX_VALUE, 60000, (Scheduler)this.scheduler, this.brokerTopicStats, new Metrics(), this.logDirFailureChannel, TierLogComponents.EMPTY(), Time.SYSTEM, true);
        OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
        Mockito.when((Object)offsetCheckpoints.fetch(this.logDir.getAbsolutePath(), this.topicPartition)).thenReturn((Object)Option.apply((Object)0L));
        DelayedOperationsMock delayedOperations = new DelayedOperationsMock();
        ArrayList<Integer> replicas = new ArrayList<Integer>();
        replicas.add(0);
        replicas.add(1);
        replicas.add(2);
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        IsrChangeListener isrChangeListener = (IsrChangeListener)Mockito.mock(IsrChangeListener.class);
        AlterIsrManager alterIsrManager = (AlterIsrManager)Mockito.mock(AlterIsrManager.class);
        this.partition = new Partition(this.topicPartition, 100L, ApiVersion$.MODULE$.latestVersion(), 0, Time.SYSTEM, isrChangeListener, (DelayedOperations)delayedOperations, (MetadataCache)Mockito.mock(MetadataCache.class), this.logManager, Option.empty(), Option.empty(), Option.empty(), alterIsrManager);
        this.partition.makeLeader(partitionState, offsetCheckpoints);
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        this.logManager.shutdown();
        this.scheduler.shutdown();
    }

    private LogConfig createLogConfig() {
        Properties logProps = new Properties();
        logProps.put(LogConfig.SegmentMsProp(), (Object)Defaults.SegmentMs());
        logProps.put(LogConfig.SegmentBytesProp(), (Object)Defaults.SegmentSize());
        logProps.put(LogConfig.RetentionMsProp(), (Object)Defaults.RetentionMs());
        logProps.put(LogConfig.RetentionBytesProp(), (Object)Defaults.RetentionSize());
        logProps.put(LogConfig.SegmentJitterMsProp(), (Object)Defaults.SegmentJitterMs());
        logProps.put(LogConfig.CleanupPolicyProp(), Defaults.CleanupPolicy());
        logProps.put(LogConfig.MaxMessageBytesProp(), (Object)Defaults.MaxMessageSize());
        logProps.put(LogConfig.IndexIntervalBytesProp(), (Object)Defaults.IndexInterval());
        logProps.put(LogConfig.SegmentIndexBytesProp(), (Object)Defaults.MaxIndexSize());
        logProps.put(LogConfig.MessageFormatVersionProp(), Defaults.MessageFormatVersion());
        logProps.put(LogConfig.FileDeleteDelayMsProp(), (Object)Defaults.FileDeleteDelayMs());
        return LogConfig.apply((Map)logProps, (Set)new HashSet());
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void updateFollowerFetchStateBench() {
        this.partition.updateFollowerFetchState(1, new LogOffsetMetadata(this.nextOffset, this.nextOffset, 0), 0L, 1L, this.nextOffset);
        this.partition.updateFollowerFetchState(2, new LogOffsetMetadata(this.nextOffset, this.nextOffset, 0), 0L, 1L, this.nextOffset);
        ++this.nextOffset;
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void updateFollowerFetchStateBenchNoChange() {
        this.partition.updateFollowerFetchState(1, new LogOffsetMetadata(this.nextOffset, this.nextOffset, 0), 0L, 1L, 100L);
        this.partition.updateFollowerFetchState(2, new LogOffsetMetadata(this.nextOffset, this.nextOffset, 0), 0L, 1L, 100L);
    }

    private class DelayedOperationsMock
    extends DelayedOperations {
        DelayedOperationsMock() {
            super(UpdateFollowerFetchStateBenchmark.this.topicPartition, null, null, null);
        }

        public int numDelayedDelete() {
            return 0;
        }
    }
}

