/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.partition;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion$;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.Partition;
import kafka.log.CleanerConfig;
import kafka.log.Defaults;
import kafka.log.LogConfig;
import kafka.log.LogManager;
import kafka.log.TierLogComponents;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.CachedConfigRepository;
import kafka.server.metadata.ConfigRepository;
import kafka.utils.KafkaScheduler;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.mockito.Mockito;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.Set;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class PartitionMakeFollowerBenchmark {
    private LogManager logManager;
    private File logDir = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
    private KafkaScheduler scheduler = new KafkaScheduler(1, "scheduler", true);
    private Partition partition;
    private List<Integer> replicas = Arrays.asList(0, 1, 2);
    private OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Setup(value=Level.Trial)
    public void setup() throws IOException {
        if (!this.logDir.mkdir()) {
            throw new IOException("error creating test directory");
        }
        this.scheduler.startup();
        LogConfig logConfig = PartitionMakeFollowerBenchmark.createLogConfig();
        List<File> logDirs = Collections.singletonList(this.logDir);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        LogDirFailureChannel logDirFailureChannel = (LogDirFailureChannel)Mockito.mock(LogDirFailureChannel.class);
        this.logManager = new LogManager((Seq)((Iterator)JavaConverters.asScalaIteratorConverter(logDirs.iterator()).asScala()).toSeq(), (Seq)((Iterator)JavaConverters.asScalaIteratorConverter(new ArrayList().iterator()).asScala()).toSeq(), (ConfigRepository)new CachedConfigRepository(), logConfig, new CleanerConfig(0, 0L, 0.0, 0, 0, 0.0, 0L, false, Integer.MAX_VALUE, "MD5"), 1, 1000L, 10000L, 10000L, 10000, 1000L, Integer.MAX_VALUE, 60000, (Scheduler)this.scheduler, brokerTopicStats, new Metrics(), logDirFailureChannel, TierLogComponents.EMPTY(), Time.SYSTEM, true);
        TopicPartition tp = new TopicPartition("topic", 0);
        Mockito.when((Object)this.offsetCheckpoints.fetch(this.logDir.getAbsolutePath(), tp)).thenReturn((Object)Option.apply((Object)0L));
        IsrChangeListener isrChangeListener = (IsrChangeListener)Mockito.mock(IsrChangeListener.class);
        AlterIsrManager alterIsrManager = (AlterIsrManager)Mockito.mock(AlterIsrManager.class);
        this.partition = new Partition(tp, 100L, ApiVersion$.MODULE$.latestVersion(), 0, Time.SYSTEM, isrChangeListener, this.delayedOperations, (MetadataCache)Mockito.mock(MetadataCache.class), this.logManager, Option.empty(), Option.empty(), Option.empty(), alterIsrManager);
        this.partition.createLogIfNotExists(true, false, this.offsetCheckpoints);
        this.executorService.submit(() -> {
            SimpleRecord[] simpleRecords = new SimpleRecord[]{new SimpleRecord(1L, "foo".getBytes(StandardCharsets.UTF_8), "1".getBytes(StandardCharsets.UTF_8)), new SimpleRecord(2L, "bar".getBytes(StandardCharsets.UTF_8), "2".getBytes(StandardCharsets.UTF_8))};
            int initialOffSet = 0;
            while (true) {
                MemoryRecords memoryRecords = MemoryRecords.withRecords((long)initialOffSet, (CompressionType)CompressionType.NONE, (Integer)0, (SimpleRecord[])simpleRecords);
                this.partition.appendRecordsToFollowerOrFutureReplica(memoryRecords, false);
                initialOffSet += 2;
            }
        });
    }

    @TearDown(value=Level.Trial)
    public void tearDown() throws IOException {
        this.executorService.shutdownNow();
        this.logManager.shutdown();
        this.scheduler.shutdown();
        Utils.delete((File)this.logDir);
    }

    @Benchmark
    public boolean testMakeFollower() {
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(0).setLeaderEpoch(0).setIsr(this.replicas).setZkVersion(1).setReplicas(this.replicas).setIsNew(true);
        return this.partition.makeFollower(partitionState, this.offsetCheckpoints);
    }

    private static LogConfig createLogConfig() {
        Properties logProps = new Properties();
        logProps.put(LogConfig.SegmentMsProp(), (Object)Defaults.SegmentMs());
        logProps.put(LogConfig.SegmentBytesProp(), (Object)Defaults.SegmentSize());
        logProps.put(LogConfig.RetentionMsProp(), (Object)Defaults.RetentionMs());
        logProps.put(LogConfig.RetentionBytesProp(), (Object)Defaults.RetentionSize());
        logProps.put(LogConfig.SegmentJitterMsProp(), (Object)Defaults.SegmentJitterMs());
        logProps.put(LogConfig.CleanupPolicyProp(), Defaults.CleanupPolicy());
        logProps.put(LogConfig.MaxMessageBytesProp(), (Object)Defaults.MaxMessageSize());
        logProps.put(LogConfig.IndexIntervalBytesProp(), (Object)Defaults.IndexInterval());
        logProps.put(LogConfig.SegmentIndexBytesProp(), (Object)Defaults.MaxIndexSize());
        logProps.put(LogConfig.MessageFormatVersionProp(), Defaults.MessageFormatVersion());
        logProps.put(LogConfig.FileDeleteDelayMsProp(), (Object)Defaults.FileDeleteDelayMs());
        return LogConfig.apply((Map)logProps, (Set)new HashSet());
    }
}

