/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.multitenant;

import io.confluent.kafka.multitenant.MultiTenantInterceptorConfig;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.MultiTenantRequestContext;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class MultiTenantRequestContextBenchmark {
    @Param(value={"500", "1000", "2000", "5000"})
    public static int topicCount;
    @Param(value={"5", "10", "50"})
    public static int partitionCount;
    @Param(value={"10", "50", "100"})
    public static int brokerCount;
    @Param(value={"false", "true"})
    public static boolean isHostNamePrefixEnabled;
    private MultiTenantPrincipal principal = new MultiTenantPrincipal("user", new TenantMetadata("tenant", "tenant_cluster_id"));
    private Metrics metrics = new Metrics();
    private TenantMetrics tenantMetrics = new TenantMetrics();
    private MultiTenantRequestContext multiTenantRequestContext;

    @Setup(value=Level.Trial)
    public void setup() {
        this.multiTenantRequestContext = this.createRequestContext();
    }

    private MultiTenantRequestContext createRequestContext() {
        HashMap<String, Object> configMap = new HashMap<String, Object>(){
            {
                this.put(KafkaConfig.BrokerIdProp(), 1);
                this.put(KafkaConfig.DefaultReplicationFactorProp(), (short)1);
                this.put(KafkaConfig.NumPartitionsProp(), 1);
                this.put("confluent.multitenant.listener.hostname.cluster.prefix.enable", isHostNamePrefixEnabled);
                this.put("confluent.multitenant.max.partitions.per.request", partitionCount);
                this.put("confluent.schema.validator.multitenant.enable", false);
            }
        };
        MultiTenantInterceptorConfig config = new MultiTenantInterceptorConfig((Map)configMap);
        RequestHeader header = new RequestHeader(ApiKeys.METADATA, ApiKeys.METADATA.latestVersion(), "clientId", 23);
        MultiTenantRequestContext context = new MultiTenantRequestContext(header, "1", null, this.principal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, (Time)new SystemTime(), this.metrics, this.tenantMetrics, config, Optional.empty(), false, Optional.empty());
        MetadataRequest metadataRequest = (MetadataRequest)MetadataRequest.Builder.allTopics().build();
        ByteBuffer requestBuffer = metadataRequest.serialize();
        context.parseRequest(requestBuffer);
        return context;
    }

    private MetadataResponse prepareResponse() {
        MetadataResponseData responseData = new MetadataResponseData();
        responseData.setThrottleTimeMs(0);
        IntStream.range(0, brokerCount).forEach(brokerId -> responseData.brokers().add((ImplicitLinkedHashCollection.Element)new MetadataResponseData.MetadataResponseBroker().setNodeId(brokerId).setHost("host_" + brokerId).setPort(9092 + brokerId).setRack("rack1")));
        responseData.setClusterId("clusterId");
        responseData.setControllerId(1);
        responseData.setClusterAuthorizedOperations(0);
        IntStream.range(0, topicCount).forEach(topicId -> {
            String topicName = topicId % 5 == 0 ? "tenant_topic-" + topicId : "othertenant_topic-" + topicId;
            MetadataResponseData.MetadataResponseTopic metadataResponseTopic = new MetadataResponseData.MetadataResponseTopic();
            metadataResponseTopic.setErrorCode(Errors.NONE.code()).setName(topicName).setIsInternal(false).setTopicAuthorizedOperations(0);
            IntStream.range(0, partitionCount).forEach(partitionId -> metadataResponseTopic.partitions().add(new MetadataResponseData.MetadataResponsePartition().setErrorCode(Errors.NONE.code()).setPartitionIndex(partitionId).setLeaderId(1).setLeaderEpoch(100).setReplicaNodes(Arrays.asList(0, 1, 2)).setObservers(Collections.emptyList()).setIsrNodes(Arrays.asList(0, 1, 2)).setOfflineReplicas(Collections.emptyList())));
            responseData.topics().add((ImplicitLinkedHashCollection.Element)metadataResponseTopic);
        });
        return new MetadataResponse(responseData, 11);
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        this.metrics.close();
    }

    @Benchmark
    public void testBuildResponseMetadataForMetadata() {
        this.multiTenantRequestContext.buildResponseSend((AbstractResponse)this.prepareResponse());
    }
}

