/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.metadata;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import kafka.controller.KafkaController;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.network.RequestChannel;
import kafka.network.RequestConvertToJson;
import kafka.server.ApiVersionManager;
import kafka.server.AutoTopicCreationManager;
import kafka.server.BrokerTopicStats;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.FetchManager;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.MetadataSupport;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.SimpleApiVersionManager;
import kafka.server.ZkAdminManager;
import kafka.server.ZkMetadataCache;
import kafka.server.ZkSupport;
import kafka.server.link.ClusterLinkAdminManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.CachedConfigRepository;
import kafka.server.metadata.ConfigRepository;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import scala.Option;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class StandardMetadataRequestBenchmark {
    @Param(value={"500", "5000"})
    private int topicCount;
    @Param(value={"10", "50"})
    private int partitionCount;
    @Param(value={"true", "false"})
    private boolean autoCreateTopic;
    private RequestChannel requestChannel = (RequestChannel)Mockito.mock(RequestChannel.class, (MockSettings)Mockito.withSettings().stubOnly());
    private RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
    private ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
    private ZkAdminManager adminManager = (ZkAdminManager)Mockito.mock(ZkAdminManager.class);
    private ClusterLinkAdminManager clusterLinkAdminManager = (ClusterLinkAdminManager)Mockito.mock(ClusterLinkAdminManager.class);
    private TransactionCoordinator transactionCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
    private KafkaController kafkaController = (KafkaController)Mockito.mock(KafkaController.class);
    private AutoTopicCreationManager autoTopicCreationManager = (AutoTopicCreationManager)Mockito.mock(AutoTopicCreationManager.class);
    private KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
    private Metrics metrics = new Metrics();
    private int brokerId = 1;
    private ZkMetadataCache metadataCache = MetadataCache.zkMetadataCache((int)this.brokerId, (boolean)false);
    private ClientQuotaManager clientQuotaManager = (ClientQuotaManager)Mockito.mock(ClientQuotaManager.class);
    private ClientRequestQuotaManager clientRequestQuotaManager = (ClientRequestQuotaManager)Mockito.mock(ClientRequestQuotaManager.class);
    private ControllerMutationQuotaManager controllerMutationQuotaManager = (ControllerMutationQuotaManager)Mockito.mock(ControllerMutationQuotaManager.class);
    private ReplicationQuotaManager replicaQuotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
    private QuotaFactory.QuotaManagers quotaManagers = new QuotaFactory.QuotaManagers(this.clientQuotaManager, this.clientQuotaManager, this.clientRequestQuotaManager, this.controllerMutationQuotaManager, this.replicaQuotaManager, this.replicaQuotaManager, this.replicaQuotaManager, this.replicaQuotaManager, Option.empty());
    private FetchManager fetchManager = (FetchManager)Mockito.mock(FetchManager.class);
    private BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private KafkaPrincipal principal = new KafkaPrincipal("User", "test-user");
    private KafkaApis kafkaApis;
    private RequestChannel.Request allTopicMetadataRequest;
    private RequestChannel.Request nonExistentTopicMetadataRequest;
    private RequestChannel.Request existingTopicMetadataRequest;
    private RequestChannel.Request singleTopicMetadataRequest;

    @Setup(value=Level.Trial)
    public void setup() {
        this.initializeMetadataCache();
        this.kafkaApis = this.createKafkaApis();
        this.allTopicMetadataRequest = this.buildAllTopicMetadataRequest();
        this.nonExistentTopicMetadataRequest = this.buildNonExistentTopicRequest();
        this.existingTopicMetadataRequest = this.buildExistingTopicRequest();
        this.singleTopicMetadataRequest = this.buildSingleTopicRequest();
    }

    private void initializeMetadataCache() {
        LinkedList liveBrokers = new LinkedList();
        LinkedList partitionStates = new LinkedList();
        IntStream.range(0, 5).forEach(brokerId -> liveBrokers.add(new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints(this.endpoints(brokerId)).setRack("rack1")));
        IntStream.range(0, this.topicCount).forEach(topicId -> {
            String topicName = "topic-" + topicId;
            IntStream.range(0, this.partitionCount).forEach(partitionId -> partitionStates.add(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(1).setLeader(this.partitionCount % 5).setLeaderEpoch(0).setIsr(Arrays.asList(0, 1, 3)).setZkVersion(1).setReplicas(Arrays.asList(0, 1, 3))));
        });
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 1, 1, 1L, partitionStates, liveBrokers, Collections.emptyMap()).build();
        this.metadataCache.updateMetadata(100, updateMetadataRequest);
    }

    private List<UpdateMetadataRequestData.UpdateMetadataEndpoint> endpoints(int brokerId) {
        return Collections.singletonList(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host_" + brokerId).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()));
    }

    private KafkaApis createKafkaApis() {
        Properties kafkaProps = new Properties();
        kafkaProps.put(KafkaConfig$.MODULE$.ZkConnectProp(), "zk");
        kafkaProps.put(KafkaConfig$.MODULE$.BrokerIdProp(), this.brokerId + "");
        return new KafkaApis(this.requestChannel, (MetadataSupport)new ZkSupport(this.adminManager, this.kafkaController, this.kafkaZkClient, Option.empty(), (MetadataCache)this.metadataCache), this.replicaManager, (ClusterLinkFactory.AdminManager)this.clusterLinkAdminManager, this.groupCoordinator, this.transactionCoordinator, this.autoTopicCreationManager, this.brokerId, new KafkaConfig((Map)kafkaProps), (ConfigRepository)new CachedConfigRepository(), (MetadataCache)this.metadataCache, this.metrics, Option.empty(), this.quotaManagers, this.fetchManager, this.brokerTopicStats, "clusterId", (Time)new SystemTime(), null, Option.empty(), (ApiVersionManager)new SimpleApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER));
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        this.kafkaApis.close();
        this.metrics.close();
    }

    private RequestChannel.Request buildAllTopicMetadataRequest() {
        MetadataRequest metadataRequest = (MetadataRequest)MetadataRequest.Builder.allTopics().build();
        RequestHeader header = new RequestHeader(metadataRequest.apiKey(), metadataRequest.version(), "", 0);
        ByteBuffer bodyBuffer = metadataRequest.serialize();
        RequestContext context = new RequestContext(header, "1", null, this.principal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
        return new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, bodyBuffer, this.requestChannelMetrics, Option.empty());
    }

    private RequestChannel.Request buildNonExistentTopicRequest() {
        List<String> topics = Arrays.asList("nonExistent");
        return this.buildTopicRequest(topics);
    }

    private RequestChannel.Request buildExistingTopicRequest() {
        List<String> topics = Arrays.asList("topic-0", "topic-1", "topic-2");
        return this.buildTopicRequest(topics);
    }

    private RequestChannel.Request buildSingleTopicRequest() {
        List<String> topics = Arrays.asList("topic-0");
        return this.buildTopicRequest(topics);
    }

    private RequestChannel.Request buildTopicRequest(List<String> topics) {
        MetadataRequest.Builder metadataRequestBuilder = new MetadataRequest.Builder(topics, this.autoCreateTopic, ApiKeys.METADATA.latestVersion());
        MetadataRequest metadataRequest = (MetadataRequest)metadataRequestBuilder.build();
        RequestHeader header = new RequestHeader(metadataRequest.apiKey(), metadataRequest.version(), "", 0);
        ByteBuffer bodyBuffer = metadataRequest.serialize();
        RequestContext context = new RequestContext(header, "1", null, this.principal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
        return new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, bodyBuffer, this.requestChannelMetrics, Option.empty());
    }

    @Benchmark
    public void testMetadataRequestForAllTopics() {
        this.kafkaApis.partitionTopicMetadataRequestByAuthorized(this.allTopicMetadataRequest);
    }

    @Benchmark
    public void testMetadataRequestForNonExistentTopics() {
        this.kafkaApis.partitionTopicMetadataRequestByAuthorized(this.nonExistentTopicMetadataRequest);
    }

    @Benchmark
    public void testMetadataRequestForExistingTopics() {
        this.kafkaApis.partitionTopicMetadataRequestByAuthorized(this.existingTopicMetadataRequest);
    }

    @Benchmark
    public void testMetadataRequestForSingleTopic() {
        this.kafkaApis.partitionTopicMetadataRequestByAuthorized(this.singleTopicMetadataRequest);
    }

    @Benchmark
    public String testRequestToJson() {
        return RequestConvertToJson.requestDesc((RequestHeader)this.allTopicMetadataRequest.header(), (Option)this.allTopicMetadataRequest.requestLog(), (boolean)this.allTopicMetadataRequest.isForwarded()).toString();
    }
}

