/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.metadata;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import kafka.server.MetadataCache;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class MultiTenantUpdateMetadataRequestBenchmark {
    @Param(value={"10000"})
    private int topicCount;
    @Param(value={"20"})
    private int partitionCount;
    private Metrics metrics = new Metrics();
    private int brokerId = 1;
    private MetadataCache metadataCache = MetadataCache.zkMetadataCache((int)this.brokerId, (boolean)true);
    private UpdateMetadataRequest updateMetadataRequest;

    @Setup(value=Level.Trial)
    public void setup() {
        this.initializeUpdateMetadataRequest();
    }

    private void initializeUpdateMetadataRequest() {
        LinkedList liveBrokers = new LinkedList();
        LinkedList partitionStates = new LinkedList();
        IntStream.range(0, 5).forEach(brokerId -> liveBrokers.add(new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints(this.endpoints(brokerId)).setRack("rack1")));
        HashMap topicIds = new HashMap(this.topicCount);
        IntStream.range(0, this.topicCount).forEach(topicId -> {
            String tenantName = "lkc-" + topicId % 5;
            String topicName = tenantName + "_topic" + topicId;
            IntStream.range(0, this.partitionCount).forEach(partitionId -> partitionStates.add(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(1).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList(0, 1, 3)).setZkVersion(1).setReplicas(Arrays.asList(0, 1, 3))));
            topicIds.put(topicName, Uuid.randomUuid());
        });
        this.updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 1, 1, 1L, partitionStates, liveBrokers, topicIds).build();
    }

    private List<UpdateMetadataRequestData.UpdateMetadataEndpoint> endpoints(int brokerId) {
        return Collections.singletonList(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host_" + brokerId).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()));
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        this.metrics.close();
    }

    @Benchmark
    public void testMetadataRequestForAllTopics() {
        this.metadataCache.updateMetadata(100, this.updateMetadataRequest);
    }
}

