/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.metadata;

import io.confluent.kafka.multitenant.MultiTenantInterceptorConfig;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.MultiTenantRequestContext;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.metrics.TenantMetrics;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import kafka.controller.KafkaController;
import kafka.coordinator.group.GroupCoordinator;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.network.RequestChannel;
import kafka.server.ApiVersionManager;
import kafka.server.AutoTopicCreationManager;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerTopicStats;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.FetchManager;
import kafka.server.FinalizedFeatureCache;
import kafka.server.ForwardingManager;
import kafka.server.KafkaApis;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.MetadataSupport;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import kafka.server.SimpleApiVersionManager;
import kafka.server.ZkAdminManager;
import kafka.server.ZkMetadataCache;
import kafka.server.ZkSupport;
import kafka.server.link.ClusterLinkAdminManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.metadata.CachedConfigRepository;
import kafka.server.metadata.ConfigRepository;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import scala.Option;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class MultiTenantMetadataRequestBenchmark {
    @Param(value={"500", "1000", "5000", "10000"})
    private int topicCount;
    @Param(value={"5", "10", "20"})
    private int partitionCount;
    private RequestChannel requestChannel = (RequestChannel)Mockito.mock(RequestChannel.class, (MockSettings)Mockito.withSettings().stubOnly());
    private RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
    private ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private GroupCoordinator groupCoordinator = (GroupCoordinator)Mockito.mock(GroupCoordinator.class);
    private ZkAdminManager adminManager = (ZkAdminManager)Mockito.mock(ZkAdminManager.class);
    private ClusterLinkAdminManager clusterLinkAdminManager = (ClusterLinkAdminManager)Mockito.mock(ClusterLinkAdminManager.class);
    private TransactionCoordinator transactionCoordinator = (TransactionCoordinator)Mockito.mock(TransactionCoordinator.class);
    private AutoTopicCreationManager autoTopicCreationManager = (AutoTopicCreationManager)Mockito.mock(AutoTopicCreationManager.class);
    private KafkaController kafkaController = (KafkaController)Mockito.mock(KafkaController.class);
    private ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
    private KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
    private Metrics metrics = new Metrics();
    private int brokerId = 1;
    private ZkMetadataCache metadataCache = MetadataCache.zkMetadataCache((int)this.brokerId, (boolean)true);
    private ClientQuotaManager clientQuotaManager = (ClientQuotaManager)Mockito.mock(ClientQuotaManager.class);
    private ClientRequestQuotaManager clientRequestQuotaManager = (ClientRequestQuotaManager)Mockito.mock(ClientRequestQuotaManager.class);
    private ReplicationQuotaManager replicaQuotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
    private ControllerMutationQuotaManager controllerMutationQuotaManager = (ControllerMutationQuotaManager)Mockito.mock(ControllerMutationQuotaManager.class);
    private QuotaFactory.QuotaManagers quotaManagers = new QuotaFactory.QuotaManagers(this.clientQuotaManager, this.clientQuotaManager, this.clientRequestQuotaManager, this.controllerMutationQuotaManager, this.replicaQuotaManager, this.replicaQuotaManager, this.replicaQuotaManager, this.replicaQuotaManager, Option.empty());
    private FetchManager fetchManager = (FetchManager)Mockito.mock(FetchManager.class);
    private BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private TenantMetrics tenantMetrics = new TenantMetrics();
    private MultiTenantPrincipal principal1 = new MultiTenantPrincipal("user", new TenantMetadata("tenant", "tenant_cluster_id"));
    private MultiTenantPrincipal principal2 = new MultiTenantPrincipal("user", new TenantMetadata("unknown", "tenant_cluster_id"));
    private KafkaApis kafkaApis;
    private RequestChannel.Request allTopicMetadataRequest;
    private RequestChannel.Request allTopicWithFilteringRequest;
    private BrokerFeatures brokerFeatures = (BrokerFeatures)Mockito.mock(BrokerFeatures.class);
    private FinalizedFeatureCache finalizedFeatureCache = (FinalizedFeatureCache)Mockito.mock(FinalizedFeatureCache.class);

    @Setup(value=Level.Trial)
    public void setup() {
        this.initializeMetadataCache();
        this.kafkaApis = this.createKafkaApis();
        this.allTopicMetadataRequest = this.buildAllTopicMetadataRequest(this.principal1);
        this.allTopicWithFilteringRequest = this.buildAllTopicMetadataRequest(this.principal2);
    }

    private void initializeMetadataCache() {
        LinkedList liveBrokers = new LinkedList();
        LinkedList partitionStates = new LinkedList();
        IntStream.range(0, 5).forEach(brokerId -> liveBrokers.add(new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints(this.endpoints(brokerId)).setRack("rack1")));
        HashMap topicIds = new HashMap(this.topicCount);
        IntStream.range(0, this.topicCount).forEach(topicId -> {
            String topicName = topicId % 5 == 0 ? "tenant_topic-" + topicId : "othertenant_topic-" + topicId;
            IntStream.range(0, this.partitionCount).forEach(partitionId -> partitionStates.add(new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topicName).setPartitionIndex(partitionId).setControllerEpoch(1).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList(0, 1, 3)).setZkVersion(1).setReplicas(Arrays.asList(0, 1, 3))));
            topicIds.put(topicName, Uuid.randomUuid());
        });
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), 1, 1, 1L, partitionStates, liveBrokers, topicIds).build();
        this.metadataCache.updateMetadata(100, updateMetadataRequest);
    }

    private List<UpdateMetadataRequestData.UpdateMetadataEndpoint> endpoints(int brokerId) {
        return Collections.singletonList(new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host_" + brokerId).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()));
    }

    private KafkaApis createKafkaApis() {
        Properties kafkaProps = new Properties();
        kafkaProps.put(KafkaConfig.ZkConnectProp(), "zk");
        kafkaProps.put(KafkaConfig.BrokerIdProp(), this.brokerId + "");
        return new KafkaApis(this.requestChannel, (MetadataSupport)new ZkSupport(this.adminManager, this.kafkaController, this.kafkaZkClient, Option.empty(), (MetadataCache)this.metadataCache), this.replicaManager, (ClusterLinkFactory.AdminManager)this.clusterLinkAdminManager, this.groupCoordinator, this.transactionCoordinator, this.autoTopicCreationManager, this.brokerId, new KafkaConfig((Map)kafkaProps), (ConfigRepository)new CachedConfigRepository(), (MetadataCache)this.metadataCache, this.metrics, Option.empty(), this.quotaManagers, this.fetchManager, this.brokerTopicStats, "clusterId", (Time)new SystemTime(), null, Option.empty(), (ApiVersionManager)new SimpleApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER));
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        this.kafkaApis.close();
        this.metrics.close();
    }

    private RequestChannel.Request buildAllTopicMetadataRequest(MultiTenantPrincipal principal) {
        MetadataRequest metadataRequest = (MetadataRequest)MetadataRequest.Builder.allTopics().build();
        ByteBuffer buffer = metadataRequest.serialize();
        RequestHeader header = new RequestHeader(metadataRequest.apiKey(), metadataRequest.version(), "", 0);
        HashMap<String, Object> configMap = new HashMap<String, Object>(){
            {
                this.put(KafkaConfig.BrokerIdProp(), 1);
                this.put(KafkaConfig.DefaultReplicationFactorProp(), (short)1);
                this.put(KafkaConfig.NumPartitionsProp(), 1);
                this.put("confluent.multitenant.listener.hostname.cluster.prefix.enable", false);
                this.put("confluent.multitenant.max.partitions.per.request", MultiTenantMetadataRequestBenchmark.this.partitionCount);
                this.put("confluent.schema.validator.multitenant.enable", false);
            }
        };
        MultiTenantInterceptorConfig config = new MultiTenantInterceptorConfig((Map)configMap);
        MultiTenantRequestContext context = new MultiTenantRequestContext(header, "1", null, principal, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, (Time)new SystemTime(), this.metrics, this.tenantMetrics, config, Optional.empty(), false, Optional.empty());
        return new RequestChannel.Request(1, (RequestContext)context, 0L, MemoryPool.NONE, buffer, this.requestChannelMetrics, Option.apply(null));
    }

    @Benchmark
    public void testMetadataRequestForAllTopics() {
        this.kafkaApis.handleTopicMetadataRequest(this.allTopicMetadataRequest);
    }

    @Benchmark
    public void testMetadataRequestForAllTopicsWithFullFiltering() {
        this.kafkaApis.handleTopicMetadataRequest(this.allTopicWithFilteringRequest);
    }
}

