/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import kafka.api.ApiVersion$;
import kafka.log.AbstractLog;
import kafka.log.AppendOrigin;
import kafka.log.Log;
import kafka.log.LogCleanerManager;
import kafka.log.LogConfig;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.MergedLog;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.KafkaScheduler;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import scala.Option;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.Set;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class MaxCompactionDelayBenchmark {
    @Param(value={"100"})
    private int numSegments;
    @Param(value={"false", "true"})
    private boolean reopen;
    private final TopicPartition topicPartition = new TopicPartition(Uuid.randomUuid().toString(), 1);
    private final File logDir = new File(System.getProperty("java.io.tmpdir"), this.topicPartition.toString());
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final KafkaScheduler scheduler = new KafkaScheduler(1, "fake-prefix", true);
    private final BufferSupplier bufferSupplier = BufferSupplier.create();
    private long timestamp = 0L;
    private MergedLog log;

    @Setup(value=Level.Invocation)
    public void setUp() {
        this.scheduler.startup();
        LogConfig logConfig = this.createLogConfig(100);
        this.log = this.createLog(this.logDir, logConfig);
        for (int i = 0; i < this.numSegments; ++i) {
            MemoryRecords createdRecords = this.buildRecords(0L, this.timestamp, 1, 0L);
            int partitionLeaderEpoch = 0;
            this.log.appendAsLeader(createdRecords, partitionLeaderEpoch, (AppendOrigin)new AppendOrigin.Client$(), ApiVersion$.MODULE$.latestVersion(), this.bufferSupplier);
            ++this.timestamp;
        }
        if (this.log.numberOfSegments() != this.numSegments) {
            throw new IllegalStateException("Expected " + this.numSegments + " but there were " + this.log.numberOfSegments());
        }
        if (this.reopen) {
            JavaConverters.asJavaCollection((Iterable)this.log.localLogSegments()).forEach(LogSegment::flush);
            LockSupport.parkNanos(10000000L);
            this.log.close();
            this.log = this.createLog(this.logDir, logConfig);
        }
    }

    @TearDown(value=Level.Invocation)
    public void tearDown() {
        this.scheduler.shutdown();
        this.log.delete();
        this.logDir.delete();
    }

    private LogConfig createLogConfig(int segmentBytes) {
        Properties logProps = new Properties();
        logProps.put(LogConfig.SegmentBytesProp(), (Object)segmentBytes);
        logProps.put(LogConfig.RetentionMsProp(), "-1");
        logProps.put(LogConfig.RetentionBytesProp(), "-1");
        logProps.put(LogConfig.CleanupPolicyProp(), "compact");
        logProps.put(LogConfig.MaxCompactionLagMsProp(), "10000");
        return LogConfig.apply((Map)logProps, (Set)new HashSet());
    }

    private MergedLog createLog(File dir, LogConfig config) {
        return Log.apply((File)dir, (LogConfig)config, (long)0L, (long)0L, (Scheduler)this.scheduler, (BrokerTopicStats)this.brokerTopicStats, (Metrics)new Metrics(), (Time)Time.SYSTEM, (int)3600000, (int)LogManager.ProducerIdExpirationCheckIntervalMs(), (LogDirFailureChannel)new LogDirFailureChannel(10), (Option)Option.empty(), (boolean)true);
    }

    private MemoryRecords buildRecords(long baseOffset, long timestamp, int count, long firstMessageId) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset);
        for (int i = 0; i < count; ++i) {
            builder.append(timestamp, "key".getBytes(), ("value-" + (firstMessageId + (long)i)).getBytes());
        }
        return builder.build();
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public Long maxCompactionDelayBenchmark() {
        return LogCleanerManager.maxCompactionDelay((AbstractLog)this.log, (long)0L, (long)System.currentTimeMillis());
    }
}

