/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion$;
import kafka.log.AppendOrigin;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogManager;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.utils.KafkaScheduler;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.Set;
import scala.runtime.AbstractFunction0;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class LogStartIncrementBenchmark {
    private static final int NUM_RECORDS = 1000;
    private final TopicPartition topicPartition = new TopicPartition(Uuid.randomUuid().toString(), 1);
    private final File logDir = new File(System.getProperty("java.io.tmpdir"), this.topicPartition.toString());
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final KafkaScheduler scheduler = new KafkaScheduler(0, "fake-prefix", false);
    private final BufferSupplier bufferSupplier = BufferSupplier.create();
    private long timestamp = 0L;
    private int partitionLeaderEpoch = 0;
    private Log log;

    @Setup(value=Level.Trial)
    public void setUp() {
        this.scheduler.startup();
        LogConfig logConfig = this.createLogConfig(1000000);
        this.log = this.createLog(this.logDir, logConfig);
        for (int i = 0; i < 1000; ++i) {
            MemoryRecords createdRecords = this.buildRecords(0L, this.timestamp, 1, 0L);
            this.log.appendAsLeader(createdRecords, this.partitionLeaderEpoch, (AppendOrigin)new AppendOrigin.Client$(), ApiVersion$.MODULE$.latestVersion(), this.bufferSupplier);
            ++this.timestamp;
            if (this.timestamp % 20L != 0L) continue;
            ++this.partitionLeaderEpoch;
        }
        if (this.log.numberOfSegments() > 1) {
            throw new IllegalStateException("Expected a single segment, but there were " + this.log.numberOfSegments());
        }
        this.log.updateHighWatermark(this.log.logEndOffset());
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        this.scheduler.shutdown();
        this.log.delete();
        this.logDir.delete();
    }

    private LogConfig createLogConfig(int segmentBytes) {
        Properties logProps = new Properties();
        logProps.put(LogConfig.SegmentBytesProp(), (Object)segmentBytes);
        logProps.put(LogConfig.RetentionMsProp(), "-1");
        logProps.put(LogConfig.RetentionBytesProp(), "-1");
        return LogConfig.apply((Map)logProps, (Set)new HashSet());
    }

    private Log createLog(File dir, LogConfig config) {
        TopicPartition topicPartition = Log.parseTopicPartitionName((File)this.logDir);
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, this.logDir, LogManager.ProducerIdExpirationCheckIntervalMs());
        AbstractFunction0<Object> mergedLogStartOffsetCbk = new AbstractFunction0<Object>(){

            public Long apply() {
                return 0L;
            }
        };
        AbstractFunction1<Object, BoxedUnit> mergedLogUpdateStartOffsetCbk = new AbstractFunction1<Object, BoxedUnit>(){

            public BoxedUnit apply(Object v1) {
                return null;
            }
        };
        return new Log(dir, config, 0L, (Scheduler)this.scheduler, this.brokerTopicStats, new Metrics(), Time.SYSTEM, 3600000, LogManager.ProducerIdExpirationCheckIntervalMs(), topicPartition, producerStateManager, null, (Function1)mergedLogUpdateStartOffsetCbk, (Function0)mergedLogStartOffsetCbk, true, true);
    }

    private MemoryRecords buildRecords(long baseOffset, long timestamp, int count, long firstMessageId) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)baseOffset);
        for (int i = 0; i < count; ++i) {
            builder.append(timestamp, "key".getBytes(), ("value-" + (firstMessageId + (long)i)).getBytes());
        }
        return builder.build();
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public Log maybeIncrementLogStartOffset() {
        this.log.maybeIncrementLogStartOffset(1000L, null);
        return this.log;
    }
}

