/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.fetchsession;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import kafka.server.FetchContext;
import kafka.server.FetchManager;
import kafka.server.FetchSessionCache;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=5)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class FetchSessionCacheBenchmark {
    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void sessionCacheBench(TestState state) {
        FetchContext context = state.fetchManager.newContext(state.fetchMetadata, (Map)state.reqData2, new ArrayList(), state.benchPrivileged);
        context.updateAndGenerateResponseData(state.respData2);
    }

    @State(value=Scope.Thread)
    public static class TestState {
        @Param(value={"2000"})
        private int cacheSize;
        @Param(value={"99", "100"})
        private int cacheUtilization;
        @Param(value={"10"})
        private int percentPrivileged;
        @Param(value={"false", "true"})
        private boolean newSession;
        @Param(value={"false", "true"})
        private boolean fetchSessionAddedPartitions;
        @Param(value={"false", "true"})
        private boolean benchPrivileged;
        @Param(value={"10"})
        private int numEvictableEntries;
        private AtomicLong msSinceEpoch;
        private final Time time = new Time(){

            public long milliseconds() {
                return msSinceEpoch.get();
            }

            public long nanoseconds() {
                return msSinceEpoch.get();
            }

            public void sleep(long ms) {
            }

            public void waitObject(Object obj, Supplier<Boolean> condition, long timeoutMs) {
            }
        };
        private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData;
        private LinkedHashMap<TopicPartition, FetchResponse.PartitionData<Records>> respData;
        private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> reqData2;
        private LinkedHashMap<TopicPartition, FetchResponse.PartitionData<Records>> respData2;
        FetchSessionCache cache;
        FetchManager fetchManager;
        List<Integer> sessions;
        List<Boolean> sessionFollower;
        FetchMetadata fetchMetadata;

        @Setup(value=Level.Invocation)
        public void setUp() throws Exception {
            this.msSinceEpoch = new AtomicLong(0L);
            this.sessionFollower = new ArrayList<Boolean>();
            this.sessions = new ArrayList<Integer>();
            int evictionMs = 500;
            this.cache = new FetchSessionCache(this.cacheSize, (long)evictionMs);
            this.fetchManager = new FetchManager(this.time, this.cache);
            this.reqData = new LinkedHashMap();
            this.reqData.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(0L, 0L, 100, Optional.empty()));
            this.reqData.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
            this.respData = new LinkedHashMap();
            this.respData.put(new TopicPartition("foo", 0), (FetchResponse.PartitionData<Records>)new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, (BaseRecords)MemoryRecords.readableRecords((ByteBuffer)ByteBuffer.allocate(0))));
            this.respData.put(new TopicPartition("foo", 1), (FetchResponse.PartitionData<Records>)new FetchResponse.PartitionData(Errors.NONE, 10L, 10L, 10L, null, (BaseRecords)MemoryRecords.readableRecords((ByteBuffer)ByteBuffer.allocate(0))));
            this.reqData2 = new LinkedHashMap();
            this.reqData2.put(new TopicPartition("foo", 0), new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty()));
            this.reqData2.put(new TopicPartition("foo", 1), new FetchRequest.PartitionData(20L, 0L, 100, Optional.empty()));
            if (this.fetchSessionAddedPartitions) {
                this.reqData2.put(new TopicPartition("foo", 2), new FetchRequest.PartitionData(15L, 0L, 100, Optional.empty()));
            }
            this.respData2 = new LinkedHashMap();
            this.respData2.put(new TopicPartition("foo", 1), (FetchResponse.PartitionData<Records>)new FetchResponse.PartitionData(Errors.NONE, 20L, 20L, 0L, null, (BaseRecords)MemoryRecords.readableRecords((ByteBuffer)ByteBuffer.allocate(0))));
            int sessionCount = (int)Math.ceil((double)this.cacheUtilization / 100.0 * (double)this.cacheSize);
            Random rand = new Random();
            for (int i = 0; i < sessionCount; ++i) {
                boolean isFollower = (double)rand.nextFloat() < (double)this.percentPrivileged / 100.0;
                FetchContext context = this.fetchManager.newContext(FetchMetadata.INITIAL, this.reqData, new ArrayList(), isFollower);
                FetchResponse resp = context.updateAndGenerateResponseData(this.respData);
                if (resp.sessionId() == 0) {
                    throw new Exception("failed to establish session");
                }
                this.sessions.add(resp.sessionId());
                this.sessionFollower.add(isFollower);
                if (i != sessionCount - this.numEvictableEntries - 1) continue;
                this.msSinceEpoch.set(evictionMs + 1);
            }
            if (this.newSession) {
                this.fetchMetadata = FetchMetadata.INITIAL;
            } else {
                int sessionToUpdate;
                boolean fetchIsFollower;
                do {
                    sessionToUpdate = rand.nextInt(this.sessions.size());
                    this.fetchMetadata = new FetchMetadata(this.sessions.get(sessionToUpdate).intValue(), 1);
                } while ((fetchIsFollower = this.sessionFollower.get(sessionToUpdate).booleanValue()) != this.benchPrivileged);
            }
            if (this.cache.size() != Math.min(sessionCount, this.cacheSize)) {
                throw new Exception("cache did not contain the expected session count");
            }
        }
    }
}

