/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.fetchsession;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.LogContext;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class FetchSessionBenchmark {
    private static final LogContext LOG_CONTEXT = new LogContext("[BenchFetchSessionHandler]=");
    @Param(value={"10", "100", "1000"})
    private int partitionCount;
    @Param(value={"0", "10", "100"})
    private int updatedPercentage;
    @Param(value={"false", "true"})
    private boolean presize;
    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> fetches;
    private FetchSessionHandler handler;

    @Setup(value=Level.Trial)
    public void setUp() {
        this.fetches = new LinkedHashMap();
        this.handler = new FetchSessionHandler(LOG_CONTEXT, 1);
        FetchSessionHandler.Builder builder = this.handler.newBuilder();
        LinkedHashMap<TopicPartition, FetchResponse.PartitionData> respMap = new LinkedHashMap<TopicPartition, FetchResponse.PartitionData>();
        for (int i = 0; i < this.partitionCount; ++i) {
            TopicPartition tp = new TopicPartition("foo", i);
            FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 200, Optional.empty());
            this.fetches.put(tp, partitionData);
            builder.add(tp, partitionData);
            respMap.put(tp, new FetchResponse.PartitionData(Errors.NONE, 0L, 0L, 0L, null, null));
        }
        builder.build();
        this.handler.handleResponse(new FetchResponse(Errors.NONE, respMap, 0, 1));
        int counter = 0;
        for (TopicPartition topicPartition : new ArrayList<TopicPartition>(this.fetches.keySet())) {
            if (this.updatedPercentage != 0 && counter % (100 / this.updatedPercentage) == 0) {
                this.fetches.remove(topicPartition);
                this.fetches.put(topicPartition, new FetchRequest.PartitionData(50L, 40L, 200, Optional.empty()));
            }
            ++counter;
        }
    }

    @Benchmark
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public void incrementalFetchSessionBuild() {
        FetchSessionHandler.Builder builder = this.presize ? this.handler.newBuilder(this.fetches.size(), true) : this.handler.newBuilder();
        for (Map.Entry<TopicPartition, FetchRequest.PartitionData> entry : this.fetches.entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        builder.build();
    }
}

