/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.fetcher;

import java.util.Optional;
import java.util.Properties;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.LogAppendInfo;
import kafka.server.BlockingSend;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkMetadata;
import kafka.server.link.ClusterLinkNetworkClient;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.jmh.fetcher.ReplicaFetcherThreadBenchmark;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import scala.Option;
import scala.collection.Map;
import scala.collection.mutable.HashMap;
import scala.compat.java8.OptionConverters;

public class ClusterLinkFetcherThreadBenchmark
extends ReplicaFetcherThreadBenchmark {
    @Override
    protected ReplicaFetcherThread createFetcherThread(KafkaConfig config, ReplicaManager replicaManager, Pool<TopicPartition, Partition> pool) {
        ClusterLinkConfig linkConfig = ClusterLinkFetcherThreadBenchmark.createClusterLinkConfig();
        ClusterLinkMetadata linkMetadata = (ClusterLinkMetadata)Mockito.mock(ClusterLinkMetadata.class);
        Mockito.when((Object)linkMetadata.linkName()).thenReturn((Object)"testLink");
        ClusterLinkFetcherManager linkFetcherManager = (ClusterLinkFetcherManager)Mockito.mock(ClusterLinkFetcherManager.class);
        ArgumentCaptor tpCaptor = ArgumentCaptor.forClass(TopicPartition.class);
        Mockito.when((Object)linkFetcherManager.partition((TopicPartition)tpCaptor.capture())).thenAnswer(unused -> Option.apply((Object)pool.get(tpCaptor.getValue())));
        ClusterLinkNetworkClient linkClient = (ClusterLinkNetworkClient)Mockito.mock(ClusterLinkNetworkClient.class);
        ReplicaQuota replicaQuota = new ReplicaQuota(){

            public boolean isQuotaExceeded() {
                return false;
            }

            public void record(long value) {
            }

            public boolean isThrottled(TopicPartition topicPartition) {
                return false;
            }
        };
        BlockingSend blockingSend = (BlockingSend)Mockito.mock(BlockingSend.class);
        return new ClusterLinkFetcherBenchThread(config, linkConfig, linkMetadata, linkFetcherManager, linkClient, replicaQuota, replicaManager, blockingSend, pool);
    }

    private static ClusterLinkConfig createClusterLinkConfig() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        return ClusterLinkConfig$.MODULE$.create((java.util.Map)props);
    }

    static class ClusterLinkFetcherBenchThread
    extends ClusterLinkFetcherThread {
        private final Pool<TopicPartition, Partition> pool;

        ClusterLinkFetcherBenchThread(KafkaConfig config, ClusterLinkConfig linkConfig, ClusterLinkMetadata linkMetadata, ClusterLinkFetcherManager linkFetcherManager, ClusterLinkNetworkClient linkClient, ReplicaQuota replicaQuota, ReplicaManager replicaManager, BlockingSend blockingSend, Pool<TopicPartition, Partition> partitions) {
            super("name", 3, config, linkConfig, linkMetadata, linkFetcherManager, new BrokerEndPoint(3, "host", 3000), new FailedPartitions(), replicaManager, replicaQuota, new Metrics(), Time.SYSTEM, Option.empty(), linkClient, blockingSend, Option.empty());
            this.pool = partitions;
        }

        public Option<Object> latestEpoch(TopicPartition topicPartition) {
            return Option.apply((Object)0);
        }

        public long logStartOffset(TopicPartition topicPartition) {
            return ((Partition)this.pool.get((Object)topicPartition)).localLogOrException().logStartOffset();
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return 0L;
        }

        public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        }

        public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            return OptionConverters.toScala(Optional.of(new OffsetAndEpoch(0L, 0)));
        }

        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData partitionData) {
            this.clearPartitionLinkFailure(topicPartition, fetchOffset);
            return Option.empty();
        }

        public boolean isReadyForFetch(TopicPartition topicpartition) {
            return true;
        }

        public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
            return 0L;
        }

        public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
            HashMap endOffsets = new HashMap();
            for (TopicPartition topicPartition : partitions.keys()) {
                endOffsets.put((Object)topicPartition, (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(topicPartition.partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(100L));
            }
            return endOffsets;
        }

        public Map<TopicPartition, FetchResponse.PartitionData<Records>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
            return new HashMap();
        }
    }
}

