/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.common;

import java.util.concurrent.TimeUnit;
import kafka.network.RequestConvertToJson;
import org.apache.kafka.common.message.ProduceRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ProduceRequest;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class ProduceRequestBenchmark {
    @Param(value={"10", "500", "1000"})
    private int topicCount;
    @Param(value={"3", "10", "20"})
    private int partitionCount;
    ProduceRequest produceRequest;

    @Setup(value=Level.Trial)
    public void setup() {
        this.produceRequest = ProduceRequest.forCurrentMagic((ProduceRequestData)new ProduceRequestData()).build(ApiKeys.PRODUCE.latestVersion());
    }

    @Benchmark
    public String testRequestToJson() {
        return RequestConvertToJson.request((AbstractRequest)this.produceRequest).toString();
    }
}

