/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestConvertToJson;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class ListOffsetRequestBenchmark {
    @Param(value={"10", "500", "1000"})
    private int topicCount;
    @Param(value={"3", "10", "20"})
    private int partitionCount;
    Map<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition> offsetData;
    ListOffsetsRequest offsetRequest;

    @Setup(value=Level.Trial)
    public void setup() {
        this.offsetData = new HashMap<TopicPartition, ListOffsetsRequestData.ListOffsetsPartition>();
        for (int topicIdx = 0; topicIdx < this.topicCount; ++topicIdx) {
            String topic = UUID.randomUUID().toString();
            for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
                ListOffsetsRequestData.ListOffsetsPartition data = new ListOffsetsRequestData.ListOffsetsPartition();
                this.offsetData.put(new TopicPartition(topic, partitionId), data);
            }
        }
        this.offsetRequest = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).build(ApiKeys.LIST_OFFSETS.latestVersion());
    }

    @Benchmark
    public String testRequestToJson() {
        return RequestConvertToJson.request((AbstractRequest)this.offsetRequest).toString();
    }
}

