/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.common;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ResponseHeader;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class FetchResponseBenchmark {
    @Param(value={"10", "500", "1000"})
    private int topicCount;
    @Param(value={"3", "10", "20"})
    private int partitionCount;
    LinkedHashMap<TopicPartition, FetchResponse.PartitionData<MemoryRecords>> responseData;
    ResponseHeader header;
    FetchResponse<MemoryRecords> fetchResponse;

    @Setup(value=Level.Trial)
    public void setup() {
        MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1000L, "key1".getBytes(StandardCharsets.UTF_8), "value1".getBytes(StandardCharsets.UTF_8)), new SimpleRecord(1001L, "key2".getBytes(StandardCharsets.UTF_8), "value2".getBytes(StandardCharsets.UTF_8)), new SimpleRecord(1002L, "key3".getBytes(StandardCharsets.UTF_8), "value3".getBytes(StandardCharsets.UTF_8))});
        this.responseData = new LinkedHashMap();
        for (int topicIdx = 0; topicIdx < this.topicCount; ++topicIdx) {
            String topic = UUID.randomUUID().toString();
            for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
                FetchResponse.PartitionData partitionData = new FetchResponse.PartitionData(Errors.NONE, 0L, 0L, 0L, Optional.empty(), Collections.emptyList(), (BaseRecords)records);
                this.responseData.put(new TopicPartition(topic, partitionId), (FetchResponse.PartitionData<MemoryRecords>)partitionData);
            }
        }
        this.header = new ResponseHeader(100, ApiKeys.FETCH.responseHeaderVersion(ApiKeys.FETCH.latestVersion()));
        this.fetchResponse = new FetchResponse(Errors.NONE, this.responseData, 0, 0);
    }

    @Benchmark
    public int testConstructFetchResponse() {
        FetchResponse fetchResponse = new FetchResponse(Errors.NONE, this.responseData, 0, 0);
        return fetchResponse.responseData().size();
    }

    @Benchmark
    public int testSerializeFetchResponse() throws IOException {
        Send send = this.fetchResponse.toSend(this.header, ApiKeys.FETCH.latestVersion());
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((TransferableChannel)channel);
        return channel.buffer().limit();
    }
}

