/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestConvertToJson;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.network.TransferableChannel;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ByteBufferChannel;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class FetchRequestBenchmark {
    @Param(value={"10", "500", "1000"})
    private int topicCount;
    @Param(value={"3", "10", "20"})
    private int partitionCount;
    Map<TopicPartition, FetchRequest.PartitionData> fetchData;
    RequestHeader header;
    FetchRequest consumerRequest;
    FetchRequest replicaRequest;
    ByteBuffer requestBuffer;

    @Setup(value=Level.Invocation)
    public void setup() {
        this.fetchData = new HashMap<TopicPartition, FetchRequest.PartitionData>();
        for (int topicIdx = 0; topicIdx < this.topicCount; ++topicIdx) {
            String topic = UUID.randomUUID().toString();
            for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
                FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(0L, 0L, 4096, Optional.empty());
                this.fetchData.put(new TopicPartition(topic, partitionId), partitionData);
            }
        }
        this.header = new RequestHeader(ApiKeys.FETCH, ApiKeys.FETCH.latestVersion(), "jmh-benchmark", 100);
        this.consumerRequest = FetchRequest.Builder.forConsumer((int)0, (int)0, this.fetchData).build(ApiKeys.FETCH.latestVersion());
        this.replicaRequest = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)1, (int)0, (int)0, this.fetchData).build(ApiKeys.FETCH.latestVersion());
        this.requestBuffer = this.consumerRequest.serialize();
    }

    @Benchmark
    public short testFetchRequestFromBuffer() {
        return AbstractRequest.parseRequest((ApiKeys)ApiKeys.FETCH, (short)ApiKeys.FETCH.latestVersion(), (ByteBuffer)this.requestBuffer, (MessageContext)MessageContext.IDENTITY).request.version();
    }

    @Benchmark
    public int testFetchRequestForConsumer() {
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)0, (int)0, this.fetchData).build(ApiKeys.FETCH.latestVersion());
        return fetchRequest.fetchData().size();
    }

    @Benchmark
    public int testFetchRequestForReplica() {
        FetchRequest fetchRequest = FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)1, (int)0, (int)0, this.fetchData).build(ApiKeys.FETCH.latestVersion());
        return fetchRequest.fetchData().size();
    }

    @Benchmark
    public int testSerializeFetchRequestForConsumer() throws IOException {
        Send send = this.consumerRequest.toSend(this.header);
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((TransferableChannel)channel);
        return channel.buffer().limit();
    }

    @Benchmark
    public int testSerializeFetchRequestForReplica() throws IOException {
        Send send = this.replicaRequest.toSend(this.header);
        ByteBufferChannel channel = new ByteBufferChannel(send.size());
        send.writeTo((TransferableChannel)channel);
        return channel.buffer().limit();
    }

    @Benchmark
    public String testRequestToJson() {
        return RequestConvertToJson.request((AbstractRequest)this.consumerRequest).toString();
    }
}

