/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.common;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import kafka.api.LeaderAndIsr;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionState;
import kafka.controller.ReplicaAssignment;
import org.apache.kafka.common.TopicPartition;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import scala.Option;
import scala.collection.JavaConverters;
import scala.collection.Seq;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=15)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class ControllerContextUnderMinIsrBenchmark {
    @Param(value={"50000", "100000", "200000"})
    private int partitionCount;
    ControllerContext controllerContext;

    @Setup(value=Level.Trial)
    public void setup() {
        ArrayList<Integer> replicas = new ArrayList<Integer>();
        replicas.add(0);
        replicas.add(1);
        replicas.add(2);
        scala.collection.immutable.Seq empty = JavaConverters.asScalaBuffer(new ArrayList()).toSeq();
        this.controllerContext = new ControllerContext();
        for (int p = 0; p < this.partitionCount; ++p) {
            TopicPartition tp = new TopicPartition(Integer.toString(p / 10), p % 10);
            ArrayList<Integer> isr = new ArrayList<Integer>();
            for (int i = 0; i <= p % 3; ++i) {
                isr.add(i);
            }
            this.controllerContext.updatePartitionFullReplicaAssignment(tp, new ReplicaAssignment((Seq)JavaConverters.asScalaBuffer(replicas).toSeq(), (Seq)empty, (Seq)empty, (Seq)empty, Option.empty()));
            this.controllerContext.putPartitionState(tp, (PartitionState)OnlinePartition$.MODULE$);
            this.controllerContext.putPartitionLeadershipInfo(tp, new LeaderIsrAndControllerEpoch(new LeaderAndIsr(0, 0, JavaConverters.asScalaBuffer(isr).toList(), 0, false, Option.empty()), 0));
            this.controllerContext.putMinIsrConfigValues(tp.topic(), 2);
        }
    }

    @Benchmark
    public int testUnderMinIsrPartitionCount() {
        return this.controllerContext.underMinIsrPartitions();
    }
}

