/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.balancer;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUnitTestUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.BalancingConstraint;
import com.linkedin.kafka.cruisecontrol.analyzer.GoalOptimizer;
import com.linkedin.kafka.cruisecontrol.analyzer.OptimizerResult;
import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.common.ClusterProperty;
import com.linkedin.kafka.cruisecontrol.common.TestConstants;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.exception.KafkaCruiseControlException;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.RandomCluster;
import com.yammer.metrics.core.MetricsRegistry;
import io.confluent.cruisecontrol.analyzer.goals.MaxReplicaMovementParallelismGoal;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=2)
@Measurement(iterations=5)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class PlanComputationBenchmark {
    @Param(value={"50001"})
    public static String numReplicas;
    @Param(value={"30"})
    public static String numBrokers;
    @Param(value={"LINEAR"})
    public static String replicaDistributionStrategy;
    private ClusterModel clusterModel;
    private GoalOptimizer optimizer;
    private List<Goal> goalByPriority;
    private String configurationStr;
    private OptimizerResult result;
    private static final long MAX_REPLICAS_PER_BROKER = 5000L;
    private static final Logger LOG;

    @Setup(value=Level.Trial)
    public void setup() throws IOException, ClusterModel.NonExistentBrokerException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Map<ClusterProperty, Number> clusterProperties = this.clusterProperties();
        this.clusterModel = RandomCluster.generate(clusterProperties);
        RandomCluster.populate((ClusterModel)this.clusterModel, clusterProperties, (TestConstants.ReplicaDistributionStrategy)TestConstants.ReplicaDistributionStrategy.valueOf((String)replicaDistributionStrategy));
        this.optimizer = this.setUpOptimizer();
        this.configurationStr = String.format("numBrokers: %s; numReplicas: %s; replicaDistributionStrategy: %s", numBrokers, numReplicas, replicaDistributionStrategy);
        LOG.info("Optimizing for {} goals {} with config ({})", new Object[]{this.goalByPriority.size(), this.goalByPriority, this.configurationStr});
    }

    private Map<ClusterProperty, Number> clusterProperties() {
        HashMap<ClusterProperty, Number> clusterProperties = new HashMap<ClusterProperty, Number>(TestConstants.BASE_PROPERTIES);
        clusterProperties.put(ClusterProperty.NUM_REPLICAS, Integer.parseInt(numReplicas));
        clusterProperties.put(ClusterProperty.NUM_BROKERS, Integer.parseInt(numBrokers));
        clusterProperties.put(ClusterProperty.NUM_RACKS, 3);
        clusterProperties.put(ClusterProperty.NUM_TOPICS, 7500);
        return clusterProperties;
    }

    @TearDown(value=Level.Trial)
    public void tearDown() throws IOException {
        if (this.result != null) {
            LOG.info("Computed {} execution proposals for plan computation with config ({})", (Object)this.result.goalProposals().size(), (Object)this.configurationStr);
        }
        this.result = null;
        this.configurationStr = null;
        this.clusterModel = null;
        this.optimizer = null;
        this.goalByPriority = null;
    }

    @Benchmark
    public void testPlanComputation() throws KafkaCruiseControlException {
        this.result = this.optimizer.optimizations(this.clusterModel, this.goalByPriority, Collections.emptySet(), Collections.emptySet(), false);
    }

    private GoalOptimizer setUpOptimizer() throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Properties props = KafkaCruiseControlUnitTestUtils.getKafkaCruiseControlProperties();
        props.setProperty("max.replicas", Long.toString(5000L));
        BalancingConstraint balancingConstraint = new BalancingConstraint(new KafkaCruiseControlConfig((Map)props));
        balancingConstraint.setResourceBalancePercentage(1.1);
        balancingConstraint.setCapacityThreshold(0.8);
        ArrayList goalNameByPriority = new ArrayList(KafkaCruiseControlConfig.DEFAULT_GOALS_LIST);
        goalNameByPriority.remove(MaxReplicaMovementParallelismGoal.class.getName());
        this.goalByPriority = new ArrayList<Goal>(goalNameByPriority.size());
        for (String goalClassName : goalNameByPriority) {
            Class<?> goalClass = Class.forName(goalClassName);
            try {
                Constructor<?> constructor = goalClass.getDeclaredConstructor(BalancingConstraint.class);
                constructor.setAccessible(true);
                this.goalByPriority.add((Goal)constructor.newInstance(balancingConstraint));
            }
            catch (NoSuchMethodException badConstructor) {
                this.goalByPriority.add((Goal)goalClass.newInstance());
            }
        }
        MetricsRegistry metricsRegistry = new MetricsRegistry();
        GoalOptimizer goalOptimizer = new GoalOptimizer(new KafkaCruiseControlConfig((Map)balancingConstraint.setProps(props)), null, KafkaCruiseControlUnitTestUtils.getMetricsRegistry((MetricsRegistry)metricsRegistry));
        return goalOptimizer;
    }

    static {
        LOG = LoggerFactory.getLogger(PlanComputationBenchmark.class);
    }
}

