/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.audit;

import io.confluent.security.audit.provider.ConfluentAuditLogProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.jmh.audit.CountExporter;

public class ProviderBenchmarkDefaults {
    static final int DISTINCT_KEYS = 10000;
    static final int USERS = 101;
    static final int TOPICS = 97;
    static final String[] ACTIONS;
    static final ApiKeys[] API_KEYS;
    static final String CLUSTER_ID = "63REM3VWREiYtMuVxZeplA";
    static ConfluentAuditLogProvider noneProvider;
    static ConfluentAuditLogProvider createProduceOneLogProvider;
    static ConfluentAuditLogProvider createProduceSomeLogProvider;
    static ConfluentAuditLogProvider createProduceAllLogProvider;
    static ConfluentAuditLogProvider everythingLogProvider;
    static ConfluentAuditLogProvider createProvider;
    static ConfluentAuditLogProvider allowProvider;
    static ConfluentAuditLogProvider denyProvider;

    private static ConfluentAuditLogProvider providerWithCountExporter(String routerConfigJson) {
        try {
            HashMap<String, String> configs = new HashMap<String, String>();
            ConfluentAuditLogProvider provider = new ConfluentAuditLogProvider();
            configs.put("confluent.security.event.router.config", routerConfigJson);
            configs.put("confluent.authorizer.authority.name", "mds.example.com");
            configs.put("bootstrap.servers", "localhost:9092");
            configs.put("confluent.security.event.logger.exporter.class", CountExporter.class.getName());
            provider.configure(configs);
            provider.onUpdate(new ClusterResource(CLUSTER_ID));
            provider.setMetrics(new Metrics());
            CompletableFuture startFuture = provider.start(configs).toCompletableFuture();
            startFuture.get(10000L, TimeUnit.MILLISECONDS);
            return provider;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ArrayList<String> actions = new ArrayList<String>();
        ArrayList<ApiKeys> apiKeys = new ArrayList<ApiKeys>();
        for (int i = 0; i < 16; ++i) {
            actions.add("Produce");
            apiKeys.add(ApiKeys.PRODUCE);
            actions.add("FetchConsumer");
            apiKeys.add(ApiKeys.FETCH);
        }
        actions.add("CreateTopics");
        apiKeys.add(ApiKeys.CREATE_TOPICS);
        ACTIONS = actions.toArray(new String[0]);
        API_KEYS = apiKeys.toArray(new ApiKeys[0]);
        noneProvider = ProviderBenchmarkDefaults.providerWithCountExporter("{\n    \"destinations\": {\n        \"topics\": {\n        }\n    },\n    \"default_topics\": {\n        \"allowed\": \"\",\n        \"denied\": \"\"\n    }\n}");
        createProduceOneLogProvider = ProviderBenchmarkDefaults.providerWithCountExporter("{\n    \"routes\": {\n        \"crn://mds.example.com/kafka=*/topic=topic0\": {\n            \"produce\": {\n                \"allowed\": \"confluent-audit-log-events-produce\",\n                \"denied\": \"confluent-audit-log-events-produce\"\n            }\n        }\n    },\n    \"destinations\": {\n        \"topics\": {\n            \"confluent-audit-log-events-allowed\": {\n                \"retention_ms\": 7776000000\n            },\n            \"confluent-audit-log-events-denied\": {\n                \"retention_ms\": 7776000000\n            },\n            \"confluent-audit-log-events-produce\": {\n                \"retention_ms\": 7776000000\n            }\n        }\n    },\n    \"default_topics\": {\n        \"allowed\": \"confluent-audit-log-events-allowed\",\n        \"denied\": \"confluent-audit-log-events-denied\"\n    }\n}");
        createProduceSomeLogProvider = ProviderBenchmarkDefaults.providerWithCountExporter("{\n    \"routes\": {\n        \"crn://mds.example.com/kafka=*/topic=topic1*\": {\n            \"produce\": {\n                \"allowed\": \"confluent-audit-log-events-produce\",\n                \"denied\": \"confluent-audit-log-events-produce\"\n            }\n        }\n    },\n    \"destinations\": {\n        \"topics\": {\n            \"confluent-audit-log-events-allowed\": {\n                \"retention_ms\": 7776000000\n            },\n            \"confluent-audit-log-events-denied\": {\n                \"retention_ms\": 7776000000\n            },\n            \"confluent-audit-log-events-produce\": {\n                \"retention_ms\": 7776000000\n            }\n        }\n    },\n    \"default_topics\": {\n        \"allowed\": \"confluent-audit-log-events-allowed\",\n        \"denied\": \"confluent-audit-log-events-denied\"\n    }\n}");
        createProduceAllLogProvider = ProviderBenchmarkDefaults.providerWithCountExporter("{\n    \"routes\": {\n        \"crn://mds.example.com/kafka=*/topic=*\": {\n            \"produce\": {\n                \"allowed\": \"confluent-audit-log-events-produce\",\n                \"denied\": \"confluent-audit-log-events-produce\"\n            }\n        }\n    },\n    \"destinations\": {\n        \"topics\": {\n            \"confluent-audit-log-events-allowed\": {\n                \"retention_ms\": 7776000000\n            },\n            \"confluent-audit-log-events-denied\": {\n                \"retention_ms\": 7776000000\n            },\n            \"confluent-audit-log-events-produce\": {\n                \"retention_ms\": 7776000000\n            }\n        }\n    },\n    \"default_topics\": {\n        \"allowed\": \"confluent-audit-log-events-allowed\",\n        \"denied\": \"confluent-audit-log-events-denied\"\n    }\n}");
        everythingLogProvider = ProviderBenchmarkDefaults.providerWithCountExporter("{\n    \"routes\": {\n        \"crn://mds.example.com/kafka=*/topic=*\": {\n            \"produce\": {\n                \"allowed\": \"confluent-audit-log-events-produce\",\n                \"denied\": \"confluent-audit-log-events-produce\"\n            },\n            \"consume\": {\n                \"allowed\": \"confluent-audit-log-events-produce\",\n                \"denied\": \"confluent-audit-log-events-produce\"\n            }\n        }\n    },\n    \"destinations\": {\n        \"topics\": {\n            \"confluent-audit-log-events-allowed\": {\n                \"retention_ms\": 7776000000\n            },\n            \"confluent-audit-log-events-denied\": {\n                \"retention_ms\": 7776000000\n            },\n            \"confluent-audit-log-events-produce\": {\n                \"retention_ms\": 7776000000\n            }\n        }\n    },\n    \"default_topics\": {\n        \"allowed\": \"confluent-audit-log-events-allowed\",\n        \"denied\": \"confluent-audit-log-events-denied\"\n    }\n}");
        createProvider = ProviderBenchmarkDefaults.providerWithCountExporter("{\n    \"destinations\": {\n        \"topics\": {\n            \"confluent-audit-log-events-allowed\": {\n                \"retention_ms\": 7776000000\n            },\n            \"confluent-audit-log-events-denied\": {\n                \"retention_ms\": 7776000000\n            }\n        }\n    },\n    \"default_topics\": {\n        \"allowed\": \"confluent-audit-log-events-allowed\",\n        \"denied\": \"confluent-audit-log-events-denied\"\n    }\n}");
        allowProvider = ProviderBenchmarkDefaults.providerWithCountExporter("{\n    \"destinations\": {\n        \"topics\": {\n            \"confluent-audit-log-events-allowed\": {\n                \"retention_ms\": 7776000000\n            },\n            \"confluent-audit-log-events-denied\": {\n                \"retention_ms\": 7776000000\n            }\n        }\n    },\n    \"default_topics\": {\n        \"allowed\": \"confluent-audit-log-events-allowed\",\n        \"denied\": \"\"\n    }\n}");
        denyProvider = ProviderBenchmarkDefaults.providerWithCountExporter("{\n    \"destinations\": {\n        \"topics\": {\n            \"confluent-audit-log-events-allowed\": {\n                \"retention_ms\": 7776000000\n            },\n            \"confluent-audit-log-events-denied\": {\n                \"retention_ms\": 7776000000\n            }\n        }\n    },\n    \"default_topics\": {\n        \"allowed\": \"\",\n        \"denied\": \"confluent-audit-log-events-denied\"\n    }\n}");
    }
}

