/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.audit;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.utils.TenantSanitizer;
import io.confluent.security.audit.provider.ConfluentAuditLogProvider;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizePolicy;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.ConfluentAuthorizationEvent;
import java.net.InetAddress;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.jmh.audit.CountExporter;
import org.apache.kafka.jmh.audit.LogAuthorizationArguments;
import org.apache.kafka.jmh.audit.MockRequestContext;
import org.apache.kafka.jmh.audit.ProviderBenchmarkDefaults;
import org.apache.kafka.server.audit.AuditEvent;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=org.openjdk.jmh.annotations.Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=2)
@Measurement(iterations=7)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class MultiTenantProviderLogAuthorizationBenchmark {
    private static final String TENANT_ID = "lkc-1234";
    private long counter = 0L;
    private final LogAuthorizationArguments[] args = new LogAuthorizationArguments[10000];
    private ConfluentAuditLogProvider provider;

    @Setup(value=Level.Trial)
    public void setUp() throws Exception {
        TenantMetadata metadata = new TenantMetadata(TENANT_ID, TENANT_ID);
        for (int i = 0; i < 10000; ++i) {
            Scope scope = Scope.kafkaClusterScope((String)"63REM3VWREiYtMuVxZeplA");
            MultiTenantPrincipal principal = new MultiTenantPrincipal("" + i % 101, metadata);
            ResourcePattern topic = new ResourcePattern(new ResourceType("Topic"), "lkc-1234_topic" + i % 97, PatternType.LITERAL);
            MockRequestContext context = new MockRequestContext(new RequestHeader(ProviderBenchmarkDefaults.API_KEYS[i % ProviderBenchmarkDefaults.API_KEYS.length], 1, "", i), "", InetAddress.getLoopbackAddress(), (KafkaPrincipal)principal, ListenerName.normalised((String)"EXTERNAL"), SecurityProtocol.SASL_SSL, "kafka");
            Action action = new Action(scope, topic.resourceType(), topic.name(), new Operation(ProviderBenchmarkDefaults.ACTIONS[i % ProviderBenchmarkDefaults.ACTIONS.length]));
            AuthorizeResult result = i % 2 == 0 ? AuthorizeResult.ALLOWED : AuthorizeResult.DENIED;
            AuthorizePolicy.SuperUser policy = new AuthorizePolicy.SuperUser(AuthorizePolicy.PolicyType.SUPER_USER, (KafkaPrincipal)principal);
            this.args[i] = new LogAuthorizationArguments(scope, context, action, result, (AuthorizePolicy)policy);
        }
        ProviderBenchmarkDefaults.noneProvider.setSanitizer(TenantSanitizer::tenantAuditEvent);
        ProviderBenchmarkDefaults.createProvider.setSanitizer(TenantSanitizer::tenantAuditEvent);
        ProviderBenchmarkDefaults.createProduceOneLogProvider.setSanitizer(TenantSanitizer::tenantAuditEvent);
        ProviderBenchmarkDefaults.createProduceSomeLogProvider.setSanitizer(TenantSanitizer::tenantAuditEvent);
        ProviderBenchmarkDefaults.createProduceAllLogProvider.setSanitizer(TenantSanitizer::tenantAuditEvent);
        ProviderBenchmarkDefaults.everythingLogProvider.setSanitizer(TenantSanitizer::tenantAuditEvent);
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        System.out.println("Topic Deliveries:");
        CountExporter ce = (CountExporter)this.provider.getEventLogger().eventExporter();
        ce.counts.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(e -> System.out.println((String)e.getKey() + "\t" + e.getValue()));
    }

    @Benchmark
    public void testLogAuthorizationNone() {
        this.provider = ProviderBenchmarkDefaults.noneProvider;
        ++this.counter;
        int index = (int)(this.counter % 10000L);
        LogAuthorizationArguments arg = this.args[index];
        this.provider.logEvent((AuditEvent)new ConfluentAuthorizationEvent(arg.sourceScope, arg.requestContext, arg.action, arg.authorizeResult, arg.authorizePolicy));
    }

    @Benchmark
    public void testLogAuthorizationCreate() {
        this.provider = ProviderBenchmarkDefaults.createProvider;
        ++this.counter;
        int index = (int)(this.counter % 10000L);
        LogAuthorizationArguments arg = this.args[index];
        this.provider.logEvent((AuditEvent)new ConfluentAuthorizationEvent(arg.sourceScope, arg.requestContext, arg.action, arg.authorizeResult, arg.authorizePolicy));
    }

    @Benchmark
    public void testLogAuthorizationCreateProduceOne() {
        this.provider = ProviderBenchmarkDefaults.createProduceOneLogProvider;
        ++this.counter;
        int index = (int)(this.counter % 10000L);
        LogAuthorizationArguments arg = this.args[index];
        this.provider.logEvent((AuditEvent)new ConfluentAuthorizationEvent(arg.sourceScope, arg.requestContext, arg.action, arg.authorizeResult, arg.authorizePolicy));
    }

    @Benchmark
    public void testLogAuthorizationCreateProduceSome() {
        this.provider = ProviderBenchmarkDefaults.createProduceSomeLogProvider;
        ++this.counter;
        int index = (int)(this.counter % 10000L);
        LogAuthorizationArguments arg = this.args[index];
        this.provider.logEvent((AuditEvent)new ConfluentAuthorizationEvent(arg.sourceScope, arg.requestContext, arg.action, arg.authorizeResult, arg.authorizePolicy));
    }

    @Benchmark
    public void testLogAuthorizationCreateProduceAll() {
        this.provider = ProviderBenchmarkDefaults.createProduceAllLogProvider;
        ++this.counter;
        int index = (int)(this.counter % 10000L);
        LogAuthorizationArguments arg = this.args[index];
        this.provider.logEvent((AuditEvent)new ConfluentAuthorizationEvent(arg.sourceScope, arg.requestContext, arg.action, arg.authorizeResult, arg.authorizePolicy));
    }

    @Benchmark
    public void testLogAuthorizationEverything() {
        this.provider = ProviderBenchmarkDefaults.everythingLogProvider;
        ++this.counter;
        int index = (int)(this.counter % 10000L);
        LogAuthorizationArguments arg = this.args[index];
        this.provider.logEvent((AuditEvent)new ConfluentAuthorizationEvent(arg.sourceScope, arg.requestContext, arg.action, arg.authorizeResult, arg.authorizePolicy));
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(MultiTenantProviderLogAuthorizationBenchmark.class.getSimpleName()).forks(2).build();
        new Runner(opt).run();
    }
}

