/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.jmh.audit;

import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.TenantMetadata;
import io.confluent.kafka.multitenant.utils.TenantSanitizer;
import io.confluent.kafka.server.plugins.auth.PlainSaslServer;
import io.confluent.security.audit.provider.ConfluentAuditLogProvider;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import javax.security.sasl.SaslServer;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.jmh.audit.AuthenticationEventArguments;
import org.apache.kafka.jmh.audit.ProviderBenchmarkDefaults;
import org.apache.kafka.server.audit.AuditEvent;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.server.audit.DefaultAuthenticationEvent;
import org.mockito.Mockito;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=2)
@Measurement(iterations=7)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class MultiTenantProviderAuthenticationEventBenchmark {
    private static final String TENANT_ID = "lkc-1234";
    private long counter = 0L;
    private final AuthenticationEventArguments[] args = new AuthenticationEventArguments[10000];
    private ConfluentAuditLogProvider provider;

    @Setup(value=Level.Trial)
    public void setUp() {
        TenantMetadata metadata = new TenantMetadata(TENANT_ID, TENANT_ID);
        for (int i = 0; i < 10000; ++i) {
            SaslAuthenticationContext authenticationContext;
            MultiTenantPrincipal principal = new MultiTenantPrincipal("" + i % 101, metadata);
            PlainSaslServer server = (PlainSaslServer)Mockito.mock(PlainSaslServer.class);
            Mockito.when((Object)server.getMechanismName()).thenReturn((Object)"PLAIN");
            if (i % 2 == 0) {
                Mockito.when((Object)server.userIdentifier()).thenReturn((Object)("APIKEY" + i % 101));
                authenticationContext = new SaslAuthenticationContext((SaslServer)server, SecurityProtocol.SASL_SSL, InetAddress.getLoopbackAddress(), SecurityProtocol.SASL_SSL.name());
                this.args[i] = new AuthenticationEventArguments((KafkaPrincipal)principal, (AuthenticationContext)authenticationContext, AuditEventStatus.SUCCESS, null);
                continue;
            }
            authenticationContext = new SaslAuthenticationContext((SaslServer)server, SecurityProtocol.SASL_SSL, InetAddress.getLoopbackAddress(), SecurityProtocol.SASL_SSL.name());
            AuthenticationErrorInfo errorInfo = new AuthenticationErrorInfo(AuditEventStatus.UNAUTHENTICATED, "", "APIKEY" + i % 101, "clusterId1");
            SaslAuthenticationException authenticationException = new SaslAuthenticationException("password not specified", errorInfo);
            this.args[i] = new AuthenticationEventArguments((KafkaPrincipal)principal, (AuthenticationContext)authenticationContext, AuditEventStatus.UNAUTHENTICATED, (AuthenticationException)authenticationException);
        }
        ProviderBenchmarkDefaults.noneProvider.setSanitizer(TenantSanitizer::tenantAuditEvent);
        ProviderBenchmarkDefaults.allowProvider.setSanitizer(TenantSanitizer::tenantAuditEvent);
        ProviderBenchmarkDefaults.denyProvider.setSanitizer(TenantSanitizer::tenantAuditEvent);
        ProviderBenchmarkDefaults.everythingLogProvider.setSanitizer(TenantSanitizer::tenantAuditEvent);
    }

    @Benchmark
    public void testLogAuthenticationNone() {
        this.provider = ProviderBenchmarkDefaults.noneProvider;
        ++this.counter;
        int index = (int)(this.counter % 10000L);
        AuthenticationEventArguments arg = this.args[index];
        this.provider.logEvent((AuditEvent)new DefaultAuthenticationEvent(arg.principal, arg.authenticationContext, arg.auditEventStatus, arg.authenticationException));
    }

    @Benchmark
    public void testLogAuthenticationSuccess() {
        this.provider = ProviderBenchmarkDefaults.allowProvider;
        ++this.counter;
        int index = (int)(this.counter % 10000L);
        AuthenticationEventArguments arg = this.args[index];
        this.provider.logEvent((AuditEvent)new DefaultAuthenticationEvent(arg.principal, arg.authenticationContext, arg.auditEventStatus, arg.authenticationException));
    }

    @Benchmark
    public void testLogAuthenticationFailure() {
        this.provider = ProviderBenchmarkDefaults.denyProvider;
        ++this.counter;
        int index = (int)(this.counter % 10000L);
        AuthenticationEventArguments arg = this.args[index];
        this.provider.logEvent((AuditEvent)new DefaultAuthenticationEvent(arg.principal, arg.authenticationContext, arg.auditEventStatus, arg.authenticationException));
    }

    @Benchmark
    public void testLogAuthenticationEvents() {
        this.provider = ProviderBenchmarkDefaults.everythingLogProvider;
        ++this.counter;
        int index = (int)(this.counter % 10000L);
        AuthenticationEventArguments arg = this.args[index];
        this.provider.logEvent((AuditEvent)new DefaultAuthenticationEvent(arg.principal, arg.authenticationContext, arg.auditEventStatus, arg.authenticationException));
    }

    public static void main(String[] args) throws RunnerException {
        Options opt = new OptionsBuilder().include(MultiTenantProviderAuthenticationEventBenchmark.class.getSimpleName()).forks(2).build();
        new Runner(opt).run();
    }
}

